// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Contact Folder Request.
 */
public class BaseContactFolderRequest extends EntityRequest implements IBaseContactFolderRequest {

    /**
     * The request for the ContactFolder
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseContactFolderRequest(final String requestUrl,
            final IBaseClient client,
            final List<Option> options,
            final Class responseClass) {
        super(requestUrl, client, options, responseClass);
    }

    /**
     * Gets the ContactFolder from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<ContactFolder> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the ContactFolder from the service
     * @return The ContactFolder from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public ContactFolder get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this ContactFolder with a source
     * @param sourceContactFolder The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final ContactFolder sourceContactFolder, final ICallback<ContactFolder> callback) {
        send(HttpMethod.PATCH, callback, sourceContactFolder);
    }

    /**
     * Patches this ContactFolder with a source
     * @param sourceContactFolder The source object with updates
     * @return The updated ContactFolder
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public ContactFolder patch(final ContactFolder sourceContactFolder) throws ClientException {
        return send(HttpMethod.PATCH, sourceContactFolder);
    }

    /**
     * Creates a ContactFolder with a new object
     * @param newContactFolder The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final ContactFolder newContactFolder, final ICallback<ContactFolder> callback) {
        send(HttpMethod.POST, callback, newContactFolder);
    }

    /**
     * Creates a ContactFolder with a new object
     * @param newContactFolder The new object to create
     * @return The created ContactFolder
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public ContactFolder post(final ContactFolder newContactFolder) throws ClientException {
        return send(HttpMethod.POST, newContactFolder);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IContactFolderRequest select(final String value) {
         getQueryOptions().add(new QueryOption("select", value));
         return (ContactFolderRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IContactFolderRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("expand", value));
         return (ContactFolderRequest)this;
     }
}
