/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IUserCollectionPage;
import com.microsoft.graph.extensions.IUserCollectionRequest;
import com.microsoft.graph.extensions.User;
import com.microsoft.graph.extensions.UserCollectionPage;
import com.microsoft.graph.extensions.UserCollectionRequest;
import com.microsoft.graph.extensions.UserCollectionRequestBuilder;
import com.microsoft.graph.extensions.UserRequestBuilder;
import com.microsoft.graph.generated.BaseUserCollectionResponse;
import com.microsoft.graph.generated.IBaseUserCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseUserCollectionRequest
extends BaseCollectionRequest<BaseUserCollectionResponse, IUserCollectionPage>
implements IBaseUserCollectionRequest {
    public BaseUserCollectionRequest(String requestUrl, IBaseClient client, List<Option> options) {
        super(requestUrl, client, options, BaseUserCollectionResponse.class, IUserCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IUserCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseUserCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IUserCollectionPage get() throws ClientException {
        BaseUserCollectionResponse response = (BaseUserCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(User newUser, ICallback<User> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new UserRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newUser, callback);
    }

    @Override
    public User post(User newUser) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new UserRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newUser);
    }

    @Override
    public IUserCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (UserCollectionRequest)this;
    }

    @Override
    public IUserCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (UserCollectionRequest)this;
    }

    @Override
    public IUserCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (UserCollectionRequest)this;
    }

    public IUserCollectionPage buildFromResponse(BaseUserCollectionResponse response) {
        UserCollectionRequestBuilder builder = response.nextLink != null ? new UserCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        UserCollectionPage page = new UserCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

