/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IMailFolderCollectionPage;
import com.microsoft.graph.extensions.IMailFolderCollectionRequest;
import com.microsoft.graph.extensions.MailFolder;
import com.microsoft.graph.extensions.MailFolderCollectionPage;
import com.microsoft.graph.extensions.MailFolderCollectionRequest;
import com.microsoft.graph.extensions.MailFolderCollectionRequestBuilder;
import com.microsoft.graph.extensions.MailFolderRequestBuilder;
import com.microsoft.graph.generated.BaseMailFolderCollectionResponse;
import com.microsoft.graph.generated.IBaseMailFolderCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseMailFolderCollectionRequest
extends BaseCollectionRequest<BaseMailFolderCollectionResponse, IMailFolderCollectionPage>
implements IBaseMailFolderCollectionRequest {
    public BaseMailFolderCollectionRequest(String requestUrl, IBaseClient client, List<Option> options) {
        super(requestUrl, client, options, BaseMailFolderCollectionResponse.class, IMailFolderCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMailFolderCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseMailFolderCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMailFolderCollectionPage get() throws ClientException {
        BaseMailFolderCollectionResponse response = (BaseMailFolderCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MailFolder newMailFolder, ICallback<MailFolder> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MailFolderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newMailFolder, callback);
    }

    @Override
    public MailFolder post(MailFolder newMailFolder) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MailFolderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newMailFolder);
    }

    @Override
    public IMailFolderCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (MailFolderCollectionRequest)this;
    }

    @Override
    public IMailFolderCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (MailFolderCollectionRequest)this;
    }

    @Override
    public IMailFolderCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (MailFolderCollectionRequest)this;
    }

    public IMailFolderCollectionPage buildFromResponse(BaseMailFolderCollectionResponse response) {
        MailFolderCollectionRequestBuilder builder = response.nextLink != null ? new MailFolderCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MailFolderCollectionPage page = new MailFolderCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

