/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.DirectoryObjectCheckMemberGroupsBody;
import com.microsoft.graph.extensions.DirectoryObjectCheckMemberGroupsCollectionPage;
import com.microsoft.graph.extensions.DirectoryObjectCheckMemberGroupsRequestBuilder;
import com.microsoft.graph.extensions.IDirectoryObjectCheckMemberGroupsCollectionPage;
import com.microsoft.graph.extensions.IDirectoryObjectCheckMemberGroupsCollectionRequest;
import com.microsoft.graph.generated.BaseDirectoryObjectCheckMemberGroupsCollectionResponse;
import com.microsoft.graph.generated.IBaseDirectoryObjectCheckMemberGroupsCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseDirectoryObjectCheckMemberGroupsCollectionRequest
extends BaseCollectionRequest<BaseDirectoryObjectCheckMemberGroupsCollectionResponse, IDirectoryObjectCheckMemberGroupsCollectionPage>
implements IBaseDirectoryObjectCheckMemberGroupsCollectionRequest {
    protected final DirectoryObjectCheckMemberGroupsBody mBody = new DirectoryObjectCheckMemberGroupsBody();

    public BaseDirectoryObjectCheckMemberGroupsCollectionRequest(String requestUrl, IBaseClient client, List<Option> options, List<String> groupIds) {
        super(requestUrl, client, options, BaseDirectoryObjectCheckMemberGroupsCollectionResponse.class, IDirectoryObjectCheckMemberGroupsCollectionPage.class);
        this.mBody.groupIds = groupIds;
    }

    @Override
    public void post(final ICallback<IDirectoryObjectCheckMemberGroupsCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDirectoryObjectCheckMemberGroupsCollectionRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDirectoryObjectCheckMemberGroupsCollectionPage post() throws ClientException {
        BaseDirectoryObjectCheckMemberGroupsCollectionResponse response = (BaseDirectoryObjectCheckMemberGroupsCollectionResponse)this.post(this.mBody);
        return this.buildFromResponse(response);
    }

    public IDirectoryObjectCheckMemberGroupsCollectionPage buildFromResponse(BaseDirectoryObjectCheckMemberGroupsCollectionResponse response) {
        DirectoryObjectCheckMemberGroupsRequestBuilder builder = response.nextLink != null ? new DirectoryObjectCheckMemberGroupsRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null) : null;
        DirectoryObjectCheckMemberGroupsCollectionPage page = new DirectoryObjectCheckMemberGroupsCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDirectoryObjectCheckMemberGroupsCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (IDirectoryObjectCheckMemberGroupsCollectionRequest)((Object)this);
    }

    @Override
    public IDirectoryObjectCheckMemberGroupsCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (IDirectoryObjectCheckMemberGroupsCollectionRequest)((Object)this);
    }

    @Override
    public IDirectoryObjectCheckMemberGroupsCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (IDirectoryObjectCheckMemberGroupsCollectionRequest)((Object)this);
    }
}

