// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Subscribed Sku Request.
 */
public class BaseSubscribedSkuRequest extends EntityRequest implements IBaseSubscribedSkuRequest {

    /**
     * The request for the SubscribedSku
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseSubscribedSkuRequest(final String requestUrl,
            final IBaseClient client,
            final List<Option> options,
            final Class responseClass) {
        super(requestUrl, client, options, responseClass);
    }

    /**
     * Gets the SubscribedSku from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<SubscribedSku> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the SubscribedSku from the service
     * @return The SubscribedSku from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public SubscribedSku get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this SubscribedSku with a source
     * @param sourceSubscribedSku The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final SubscribedSku sourceSubscribedSku, final ICallback<SubscribedSku> callback) {
        send(HttpMethod.PATCH, callback, sourceSubscribedSku);
    }

    /**
     * Patches this SubscribedSku with a source
     * @param sourceSubscribedSku The source object with updates
     * @return The updated SubscribedSku
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public SubscribedSku patch(final SubscribedSku sourceSubscribedSku) throws ClientException {
        return send(HttpMethod.PATCH, sourceSubscribedSku);
    }

    /**
     * Creates a SubscribedSku with a new object
     * @param newSubscribedSku The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final SubscribedSku newSubscribedSku, final ICallback<SubscribedSku> callback) {
        send(HttpMethod.POST, callback, newSubscribedSku);
    }

    /**
     * Creates a SubscribedSku with a new object
     * @param newSubscribedSku The new object to create
     * @return The created SubscribedSku
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public SubscribedSku post(final SubscribedSku newSubscribedSku) throws ClientException {
        return send(HttpMethod.POST, newSubscribedSku);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public ISubscribedSkuRequest select(final String value) {
         getQueryOptions().add(new QueryOption("select", value));
         return (SubscribedSkuRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public ISubscribedSkuRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("expand", value));
         return (SubscribedSkuRequest)this;
     }
}
