// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Drive Item Delta Request.
 */
public class BaseDriveItemDeltaRequest extends BaseRequest implements IBaseDriveItemDeltaRequest {

    /**
     * The request for this DriveItemDelta
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseDriveItemDeltaRequest(final String requestUrl, final IBaseClient client, final List<Option> options) {
        super(requestUrl, client, options, DriveItem.class);

    }

    /**
     * Gets the DriveItem
     *
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<DriveItem> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the DriveItem
     *
     * @return The DriveItem
     * @throws ClientException An exception occurs if there was an error while the request was sent.
     */
    public DriveItem get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IDriveItemDeltaRequest select(final String value) {
        getQueryOptions().add(new QueryOption("select", value));
        return (DriveItemDeltaRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IDriveItemDeltaRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("expand", value));
        return (DriveItemDeltaRequest)this;
    }
}
