// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Directory Object Get Member Objects Request Builder.
 */
public class BaseDirectoryObjectGetMemberObjectsRequestBuilder extends BaseRequestBuilder {

    public final Boolean mSecurityEnabledOnly;

    /**
     * The request builder for this DirectoryObjectGetMemberObjects
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseDirectoryObjectGetMemberObjectsRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> options, final Boolean securityEnabledOnly) {
        super(requestUrl, client, options);
        mSecurityEnabledOnly = securityEnabledOnly;
    }

    /**
     * Creates the IDirectoryObjectGetMemberObjectsRequest
     *
     * @return The IDirectoryObjectGetMemberObjectsRequest instance
     */
    public IDirectoryObjectGetMemberObjectsRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IDirectoryObjectGetMemberObjectsRequest with specific options instead of the existing options
     *
     * @param options the options for the request
     * @return The IDirectoryObjectGetMemberObjectsRequest instance
     */
    public IDirectoryObjectGetMemberObjectsRequest buildRequest(final List<Option> options) {
        return new DirectoryObjectGetMemberObjectsRequest(getRequestUrl(), getClient(), options, mSecurityEnabledOnly);
    }
}
