/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.callrecords;

import com.microsoft.graph.models.callrecords.AudioCodec;
import com.microsoft.graph.models.callrecords.MediaStreamDirection;
import com.microsoft.graph.models.callrecords.VideoCodec;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MediaStream
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public MediaStream() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static MediaStream createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new MediaStream();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public AudioCodec getAudioCodec() {
        return (AudioCodec)((Object)this.backingStore.get("audioCodec"));
    }

    @Nullable
    public Float getAverageAudioDegradation() {
        return (Float)this.backingStore.get("averageAudioDegradation");
    }

    @Nullable
    public PeriodAndDuration getAverageAudioNetworkJitter() {
        return (PeriodAndDuration)this.backingStore.get("averageAudioNetworkJitter");
    }

    @Nullable
    public Long getAverageBandwidthEstimate() {
        return (Long)this.backingStore.get("averageBandwidthEstimate");
    }

    @Nullable
    public PeriodAndDuration getAverageFreezeDuration() {
        return (PeriodAndDuration)this.backingStore.get("averageFreezeDuration");
    }

    @Nullable
    public PeriodAndDuration getAverageJitter() {
        return (PeriodAndDuration)this.backingStore.get("averageJitter");
    }

    @Nullable
    public Float getAveragePacketLossRate() {
        return (Float)this.backingStore.get("averagePacketLossRate");
    }

    @Nullable
    public Float getAverageRatioOfConcealedSamples() {
        return (Float)this.backingStore.get("averageRatioOfConcealedSamples");
    }

    @Nullable
    public Float getAverageReceivedFrameRate() {
        return (Float)this.backingStore.get("averageReceivedFrameRate");
    }

    @Nullable
    public PeriodAndDuration getAverageRoundTripTime() {
        return (PeriodAndDuration)this.backingStore.get("averageRoundTripTime");
    }

    @Nullable
    public Float getAverageVideoFrameLossPercentage() {
        return (Float)this.backingStore.get("averageVideoFrameLossPercentage");
    }

    @Nullable
    public Float getAverageVideoFrameRate() {
        return (Float)this.backingStore.get("averageVideoFrameRate");
    }

    @Nullable
    public Float getAverageVideoPacketLossRate() {
        return (Float)this.backingStore.get("averageVideoPacketLossRate");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public OffsetDateTime getEndDateTime() {
        return (OffsetDateTime)this.backingStore.get("endDateTime");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(31);
        deserializerMap.put("audioCodec", n -> this.setAudioCodec((AudioCodec)n.getEnumValue(AudioCodec::forValue)));
        deserializerMap.put("averageAudioDegradation", n -> this.setAverageAudioDegradation(n.getFloatValue()));
        deserializerMap.put("averageAudioNetworkJitter", n -> this.setAverageAudioNetworkJitter(n.getPeriodAndDurationValue()));
        deserializerMap.put("averageBandwidthEstimate", n -> this.setAverageBandwidthEstimate(n.getLongValue()));
        deserializerMap.put("averageFreezeDuration", n -> this.setAverageFreezeDuration(n.getPeriodAndDurationValue()));
        deserializerMap.put("averageJitter", n -> this.setAverageJitter(n.getPeriodAndDurationValue()));
        deserializerMap.put("averagePacketLossRate", n -> this.setAveragePacketLossRate(n.getFloatValue()));
        deserializerMap.put("averageRatioOfConcealedSamples", n -> this.setAverageRatioOfConcealedSamples(n.getFloatValue()));
        deserializerMap.put("averageReceivedFrameRate", n -> this.setAverageReceivedFrameRate(n.getFloatValue()));
        deserializerMap.put("averageRoundTripTime", n -> this.setAverageRoundTripTime(n.getPeriodAndDurationValue()));
        deserializerMap.put("averageVideoFrameLossPercentage", n -> this.setAverageVideoFrameLossPercentage(n.getFloatValue()));
        deserializerMap.put("averageVideoFrameRate", n -> this.setAverageVideoFrameRate(n.getFloatValue()));
        deserializerMap.put("averageVideoPacketLossRate", n -> this.setAverageVideoPacketLossRate(n.getFloatValue()));
        deserializerMap.put("endDateTime", n -> this.setEndDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("isAudioForwardErrorCorrectionUsed", n -> this.setIsAudioForwardErrorCorrectionUsed(n.getBooleanValue()));
        deserializerMap.put("lowFrameRateRatio", n -> this.setLowFrameRateRatio(n.getFloatValue()));
        deserializerMap.put("lowVideoProcessingCapabilityRatio", n -> this.setLowVideoProcessingCapabilityRatio(n.getFloatValue()));
        deserializerMap.put("maxAudioNetworkJitter", n -> this.setMaxAudioNetworkJitter(n.getPeriodAndDurationValue()));
        deserializerMap.put("maxJitter", n -> this.setMaxJitter(n.getPeriodAndDurationValue()));
        deserializerMap.put("maxPacketLossRate", n -> this.setMaxPacketLossRate(n.getFloatValue()));
        deserializerMap.put("maxRatioOfConcealedSamples", n -> this.setMaxRatioOfConcealedSamples(n.getFloatValue()));
        deserializerMap.put("maxRoundTripTime", n -> this.setMaxRoundTripTime(n.getPeriodAndDurationValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("packetUtilization", n -> this.setPacketUtilization(n.getLongValue()));
        deserializerMap.put("postForwardErrorCorrectionPacketLossRate", n -> this.setPostForwardErrorCorrectionPacketLossRate(n.getFloatValue()));
        deserializerMap.put("rmsFreezeDuration", n -> this.setRmsFreezeDuration(n.getPeriodAndDurationValue()));
        deserializerMap.put("startDateTime", n -> this.setStartDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("streamDirection", n -> this.setStreamDirection((MediaStreamDirection)n.getEnumValue(MediaStreamDirection::forValue)));
        deserializerMap.put("streamId", n -> this.setStreamId(n.getStringValue()));
        deserializerMap.put("videoCodec", n -> this.setVideoCodec((VideoCodec)n.getEnumValue(VideoCodec::forValue)));
        deserializerMap.put("wasMediaBypassed", n -> this.setWasMediaBypassed(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsAudioForwardErrorCorrectionUsed() {
        return (Boolean)this.backingStore.get("isAudioForwardErrorCorrectionUsed");
    }

    @Nullable
    public Float getLowFrameRateRatio() {
        return (Float)this.backingStore.get("lowFrameRateRatio");
    }

    @Nullable
    public Float getLowVideoProcessingCapabilityRatio() {
        return (Float)this.backingStore.get("lowVideoProcessingCapabilityRatio");
    }

    @Nullable
    public PeriodAndDuration getMaxAudioNetworkJitter() {
        return (PeriodAndDuration)this.backingStore.get("maxAudioNetworkJitter");
    }

    @Nullable
    public PeriodAndDuration getMaxJitter() {
        return (PeriodAndDuration)this.backingStore.get("maxJitter");
    }

    @Nullable
    public Float getMaxPacketLossRate() {
        return (Float)this.backingStore.get("maxPacketLossRate");
    }

    @Nullable
    public Float getMaxRatioOfConcealedSamples() {
        return (Float)this.backingStore.get("maxRatioOfConcealedSamples");
    }

    @Nullable
    public PeriodAndDuration getMaxRoundTripTime() {
        return (PeriodAndDuration)this.backingStore.get("maxRoundTripTime");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Long getPacketUtilization() {
        return (Long)this.backingStore.get("packetUtilization");
    }

    @Nullable
    public Float getPostForwardErrorCorrectionPacketLossRate() {
        return (Float)this.backingStore.get("postForwardErrorCorrectionPacketLossRate");
    }

    @Nullable
    public PeriodAndDuration getRmsFreezeDuration() {
        return (PeriodAndDuration)this.backingStore.get("rmsFreezeDuration");
    }

    @Nullable
    public OffsetDateTime getStartDateTime() {
        return (OffsetDateTime)this.backingStore.get("startDateTime");
    }

    @Nullable
    public MediaStreamDirection getStreamDirection() {
        return (MediaStreamDirection)((Object)this.backingStore.get("streamDirection"));
    }

    @Nullable
    public String getStreamId() {
        return (String)this.backingStore.get("streamId");
    }

    @Nullable
    public VideoCodec getVideoCodec() {
        return (VideoCodec)((Object)this.backingStore.get("videoCodec"));
    }

    @Nullable
    public Boolean getWasMediaBypassed() {
        return (Boolean)this.backingStore.get("wasMediaBypassed");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeEnumValue("audioCodec", (Enum)this.getAudioCodec());
        writer.writeFloatValue("averageAudioDegradation", this.getAverageAudioDegradation());
        writer.writePeriodAndDurationValue("averageAudioNetworkJitter", this.getAverageAudioNetworkJitter());
        writer.writeLongValue("averageBandwidthEstimate", this.getAverageBandwidthEstimate());
        writer.writePeriodAndDurationValue("averageFreezeDuration", this.getAverageFreezeDuration());
        writer.writePeriodAndDurationValue("averageJitter", this.getAverageJitter());
        writer.writeFloatValue("averagePacketLossRate", this.getAveragePacketLossRate());
        writer.writeFloatValue("averageRatioOfConcealedSamples", this.getAverageRatioOfConcealedSamples());
        writer.writeFloatValue("averageReceivedFrameRate", this.getAverageReceivedFrameRate());
        writer.writePeriodAndDurationValue("averageRoundTripTime", this.getAverageRoundTripTime());
        writer.writeFloatValue("averageVideoFrameLossPercentage", this.getAverageVideoFrameLossPercentage());
        writer.writeFloatValue("averageVideoFrameRate", this.getAverageVideoFrameRate());
        writer.writeFloatValue("averageVideoPacketLossRate", this.getAverageVideoPacketLossRate());
        writer.writeOffsetDateTimeValue("endDateTime", this.getEndDateTime());
        writer.writeBooleanValue("isAudioForwardErrorCorrectionUsed", this.getIsAudioForwardErrorCorrectionUsed());
        writer.writeFloatValue("lowFrameRateRatio", this.getLowFrameRateRatio());
        writer.writeFloatValue("lowVideoProcessingCapabilityRatio", this.getLowVideoProcessingCapabilityRatio());
        writer.writePeriodAndDurationValue("maxAudioNetworkJitter", this.getMaxAudioNetworkJitter());
        writer.writePeriodAndDurationValue("maxJitter", this.getMaxJitter());
        writer.writeFloatValue("maxPacketLossRate", this.getMaxPacketLossRate());
        writer.writeFloatValue("maxRatioOfConcealedSamples", this.getMaxRatioOfConcealedSamples());
        writer.writePeriodAndDurationValue("maxRoundTripTime", this.getMaxRoundTripTime());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeLongValue("packetUtilization", this.getPacketUtilization());
        writer.writeFloatValue("postForwardErrorCorrectionPacketLossRate", this.getPostForwardErrorCorrectionPacketLossRate());
        writer.writePeriodAndDurationValue("rmsFreezeDuration", this.getRmsFreezeDuration());
        writer.writeOffsetDateTimeValue("startDateTime", this.getStartDateTime());
        writer.writeEnumValue("streamDirection", (Enum)this.getStreamDirection());
        writer.writeStringValue("streamId", this.getStreamId());
        writer.writeEnumValue("videoCodec", (Enum)this.getVideoCodec());
        writer.writeBooleanValue("wasMediaBypassed", this.getWasMediaBypassed());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAudioCodec(@Nullable AudioCodec value) {
        this.backingStore.set("audioCodec", (Object)value);
    }

    public void setAverageAudioDegradation(@Nullable Float value) {
        this.backingStore.set("averageAudioDegradation", (Object)value);
    }

    public void setAverageAudioNetworkJitter(@Nullable PeriodAndDuration value) {
        this.backingStore.set("averageAudioNetworkJitter", (Object)value);
    }

    public void setAverageBandwidthEstimate(@Nullable Long value) {
        this.backingStore.set("averageBandwidthEstimate", (Object)value);
    }

    public void setAverageFreezeDuration(@Nullable PeriodAndDuration value) {
        this.backingStore.set("averageFreezeDuration", (Object)value);
    }

    public void setAverageJitter(@Nullable PeriodAndDuration value) {
        this.backingStore.set("averageJitter", (Object)value);
    }

    public void setAveragePacketLossRate(@Nullable Float value) {
        this.backingStore.set("averagePacketLossRate", (Object)value);
    }

    public void setAverageRatioOfConcealedSamples(@Nullable Float value) {
        this.backingStore.set("averageRatioOfConcealedSamples", (Object)value);
    }

    public void setAverageReceivedFrameRate(@Nullable Float value) {
        this.backingStore.set("averageReceivedFrameRate", (Object)value);
    }

    public void setAverageRoundTripTime(@Nullable PeriodAndDuration value) {
        this.backingStore.set("averageRoundTripTime", (Object)value);
    }

    public void setAverageVideoFrameLossPercentage(@Nullable Float value) {
        this.backingStore.set("averageVideoFrameLossPercentage", (Object)value);
    }

    public void setAverageVideoFrameRate(@Nullable Float value) {
        this.backingStore.set("averageVideoFrameRate", (Object)value);
    }

    public void setAverageVideoPacketLossRate(@Nullable Float value) {
        this.backingStore.set("averageVideoPacketLossRate", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setEndDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("endDateTime", (Object)value);
    }

    public void setIsAudioForwardErrorCorrectionUsed(@Nullable Boolean value) {
        this.backingStore.set("isAudioForwardErrorCorrectionUsed", (Object)value);
    }

    public void setLowFrameRateRatio(@Nullable Float value) {
        this.backingStore.set("lowFrameRateRatio", (Object)value);
    }

    public void setLowVideoProcessingCapabilityRatio(@Nullable Float value) {
        this.backingStore.set("lowVideoProcessingCapabilityRatio", (Object)value);
    }

    public void setMaxAudioNetworkJitter(@Nullable PeriodAndDuration value) {
        this.backingStore.set("maxAudioNetworkJitter", (Object)value);
    }

    public void setMaxJitter(@Nullable PeriodAndDuration value) {
        this.backingStore.set("maxJitter", (Object)value);
    }

    public void setMaxPacketLossRate(@Nullable Float value) {
        this.backingStore.set("maxPacketLossRate", (Object)value);
    }

    public void setMaxRatioOfConcealedSamples(@Nullable Float value) {
        this.backingStore.set("maxRatioOfConcealedSamples", (Object)value);
    }

    public void setMaxRoundTripTime(@Nullable PeriodAndDuration value) {
        this.backingStore.set("maxRoundTripTime", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPacketUtilization(@Nullable Long value) {
        this.backingStore.set("packetUtilization", (Object)value);
    }

    public void setPostForwardErrorCorrectionPacketLossRate(@Nullable Float value) {
        this.backingStore.set("postForwardErrorCorrectionPacketLossRate", (Object)value);
    }

    public void setRmsFreezeDuration(@Nullable PeriodAndDuration value) {
        this.backingStore.set("rmsFreezeDuration", (Object)value);
    }

    public void setStartDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("startDateTime", (Object)value);
    }

    public void setStreamDirection(@Nullable MediaStreamDirection value) {
        this.backingStore.set("streamDirection", (Object)value);
    }

    public void setStreamId(@Nullable String value) {
        this.backingStore.set("streamId", (Object)value);
    }

    public void setVideoCodec(@Nullable VideoCodec value) {
        this.backingStore.set("videoCodec", (Object)value);
    }

    public void setWasMediaBypassed(@Nullable Boolean value) {
        this.backingStore.set("wasMediaBypassed", (Object)value);
    }
}

