/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.WindowsDeviceAccount;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class UpdateWindowsDeviceAccountActionParameter
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public UpdateWindowsDeviceAccountActionParameter() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static UpdateWindowsDeviceAccountActionParameter createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UpdateWindowsDeviceAccountActionParameter();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Boolean getCalendarSyncEnabled() {
        return (Boolean)this.backingStore.get("calendarSyncEnabled");
    }

    @Nullable
    public WindowsDeviceAccount getDeviceAccount() {
        return (WindowsDeviceAccount)this.backingStore.get("deviceAccount");
    }

    @Nullable
    public String getDeviceAccountEmail() {
        return (String)this.backingStore.get("deviceAccountEmail");
    }

    @Nullable
    public String getExchangeServer() {
        return (String)this.backingStore.get("exchangeServer");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("calendarSyncEnabled", n -> this.setCalendarSyncEnabled(n.getBooleanValue()));
        deserializerMap.put("deviceAccount", n -> this.setDeviceAccount((WindowsDeviceAccount)n.getObjectValue(WindowsDeviceAccount::createFromDiscriminatorValue)));
        deserializerMap.put("deviceAccountEmail", n -> this.setDeviceAccountEmail(n.getStringValue()));
        deserializerMap.put("exchangeServer", n -> this.setExchangeServer(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("passwordRotationEnabled", n -> this.setPasswordRotationEnabled(n.getBooleanValue()));
        deserializerMap.put("sessionInitiationProtocalAddress", n -> this.setSessionInitiationProtocalAddress(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Boolean getPasswordRotationEnabled() {
        return (Boolean)this.backingStore.get("passwordRotationEnabled");
    }

    @Nullable
    public String getSessionInitiationProtocalAddress() {
        return (String)this.backingStore.get("sessionInitiationProtocalAddress");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("calendarSyncEnabled", this.getCalendarSyncEnabled());
        writer.writeObjectValue("deviceAccount", (Parsable)this.getDeviceAccount(), new Parsable[0]);
        writer.writeStringValue("deviceAccountEmail", this.getDeviceAccountEmail());
        writer.writeStringValue("exchangeServer", this.getExchangeServer());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeBooleanValue("passwordRotationEnabled", this.getPasswordRotationEnabled());
        writer.writeStringValue("sessionInitiationProtocalAddress", this.getSessionInitiationProtocalAddress());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCalendarSyncEnabled(@Nullable Boolean value) {
        this.backingStore.set("calendarSyncEnabled", (Object)value);
    }

    public void setDeviceAccount(@Nullable WindowsDeviceAccount value) {
        this.backingStore.set("deviceAccount", (Object)value);
    }

    public void setDeviceAccountEmail(@Nullable String value) {
        this.backingStore.set("deviceAccountEmail", (Object)value);
    }

    public void setExchangeServer(@Nullable String value) {
        this.backingStore.set("exchangeServer", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPasswordRotationEnabled(@Nullable Boolean value) {
        this.backingStore.set("passwordRotationEnabled", (Object)value);
    }

    public void setSessionInitiationProtocalAddress(@Nullable String value) {
        this.backingStore.set("sessionInitiationProtocalAddress", (Object)value);
    }
}

