/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.termstore.Set;
import com.microsoft.graph.models.termstore.Term;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TermColumn
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public TermColumn() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static TermColumn createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new TermColumn();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public Boolean getAllowMultipleValues() {
        return (Boolean)this.backingStore.get("allowMultipleValues");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("allowMultipleValues", n -> this.setAllowMultipleValues(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("parentTerm", n -> this.setParentTerm((Term)n.getObjectValue(Term::createFromDiscriminatorValue)));
        deserializerMap.put("showFullyQualifiedName", n -> this.setShowFullyQualifiedName(n.getBooleanValue()));
        deserializerMap.put("termSet", n -> this.setTermSet((Set)n.getObjectValue(Set::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Term getParentTerm() {
        return (Term)this.backingStore.get("parentTerm");
    }

    @Nullable
    public Boolean getShowFullyQualifiedName() {
        return (Boolean)this.backingStore.get("showFullyQualifiedName");
    }

    @Nullable
    public Set getTermSet() {
        return (Set)this.backingStore.get("termSet");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("allowMultipleValues", this.getAllowMultipleValues());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("parentTerm", (Parsable)this.getParentTerm(), new Parsable[0]);
        writer.writeBooleanValue("showFullyQualifiedName", this.getShowFullyQualifiedName());
        writer.writeObjectValue("termSet", (Parsable)this.getTermSet(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAllowMultipleValues(@Nullable Boolean value) {
        this.backingStore.set("allowMultipleValues", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setParentTerm(@Nullable Term value) {
        this.backingStore.set("parentTerm", (Object)value);
    }

    public void setShowFullyQualifiedName(@Nullable Boolean value) {
        this.backingStore.set("showFullyQualifiedName", (Object)value);
    }

    public void setTermSet(@Nullable Set value) {
        this.backingStore.set("termSet", (Object)value);
    }
}

