/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PhysicalAddress
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public PhysicalAddress() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static PhysicalAddress createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new PhysicalAddress();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getCity() {
        return (String)this.backingStore.get("city");
    }

    @Nullable
    public String getCountryOrRegion() {
        return (String)this.backingStore.get("countryOrRegion");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("city", n -> this.setCity(n.getStringValue()));
        deserializerMap.put("countryOrRegion", n -> this.setCountryOrRegion(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("postalCode", n -> this.setPostalCode(n.getStringValue()));
        deserializerMap.put("state", n -> this.setState(n.getStringValue()));
        deserializerMap.put("street", n -> this.setStreet(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getPostalCode() {
        return (String)this.backingStore.get("postalCode");
    }

    @Nullable
    public String getState() {
        return (String)this.backingStore.get("state");
    }

    @Nullable
    public String getStreet() {
        return (String)this.backingStore.get("street");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("city", this.getCity());
        writer.writeStringValue("countryOrRegion", this.getCountryOrRegion());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("postalCode", this.getPostalCode());
        writer.writeStringValue("state", this.getState());
        writer.writeStringValue("street", this.getStreet());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCity(@Nullable String value) {
        this.backingStore.set("city", (Object)value);
    }

    public void setCountryOrRegion(@Nullable String value) {
        this.backingStore.set("countryOrRegion", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPostalCode(@Nullable String value) {
        this.backingStore.set("postalCode", (Object)value);
    }

    public void setState(@Nullable String value) {
        this.backingStore.set("state", (Object)value);
    }

    public void setStreet(@Nullable String value) {
        this.backingStore.set("street", (Object)value);
    }
}

