/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.EducationGender;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EducationStudent
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public EducationStudent() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static EducationStudent createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new EducationStudent();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public LocalDate getBirthDate() {
        return (LocalDate)this.backingStore.get("birthDate");
    }

    @Nullable
    public String getExternalId() {
        return (String)this.backingStore.get("externalId");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("birthDate", n -> this.setBirthDate(n.getLocalDateValue()));
        deserializerMap.put("externalId", n -> this.setExternalId(n.getStringValue()));
        deserializerMap.put("gender", n -> this.setGender((EducationGender)n.getEnumValue(EducationGender::forValue)));
        deserializerMap.put("grade", n -> this.setGrade(n.getStringValue()));
        deserializerMap.put("graduationYear", n -> this.setGraduationYear(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("studentNumber", n -> this.setStudentNumber(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public EducationGender getGender() {
        return (EducationGender)((Object)this.backingStore.get("gender"));
    }

    @Nullable
    public String getGrade() {
        return (String)this.backingStore.get("grade");
    }

    @Nullable
    public String getGraduationYear() {
        return (String)this.backingStore.get("graduationYear");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getStudentNumber() {
        return (String)this.backingStore.get("studentNumber");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeLocalDateValue("birthDate", this.getBirthDate());
        writer.writeStringValue("externalId", this.getExternalId());
        writer.writeEnumValue("gender", (Enum)this.getGender());
        writer.writeStringValue("grade", this.getGrade());
        writer.writeStringValue("graduationYear", this.getGraduationYear());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("studentNumber", this.getStudentNumber());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setBirthDate(@Nullable LocalDate value) {
        this.backingStore.set("birthDate", (Object)value);
    }

    public void setExternalId(@Nullable String value) {
        this.backingStore.set("externalId", (Object)value);
    }

    public void setGender(@Nullable EducationGender value) {
        this.backingStore.set("gender", (Object)value);
    }

    public void setGrade(@Nullable String value) {
        this.backingStore.set("grade", (Object)value);
    }

    public void setGraduationYear(@Nullable String value) {
        this.backingStore.set("graduationYear", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setStudentNumber(@Nullable String value) {
        this.backingStore.set("studentNumber", (Object)value);
    }
}

