/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AutomaticRepliesStatus;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.ExternalAudienceScope;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AutomaticRepliesSetting
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AutomaticRepliesSetting() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AutomaticRepliesSetting createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AutomaticRepliesSetting();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public ExternalAudienceScope getExternalAudience() {
        return (ExternalAudienceScope)((Object)this.backingStore.get("externalAudience"));
    }

    @Nullable
    public String getExternalReplyMessage() {
        return (String)this.backingStore.get("externalReplyMessage");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("externalAudience", n -> this.setExternalAudience((ExternalAudienceScope)n.getEnumValue(ExternalAudienceScope::forValue)));
        deserializerMap.put("externalReplyMessage", n -> this.setExternalReplyMessage(n.getStringValue()));
        deserializerMap.put("internalReplyMessage", n -> this.setInternalReplyMessage(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("scheduledEndDateTime", n -> this.setScheduledEndDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("scheduledStartDateTime", n -> this.setScheduledStartDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("status", n -> this.setStatus((AutomaticRepliesStatus)n.getEnumValue(AutomaticRepliesStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getInternalReplyMessage() {
        return (String)this.backingStore.get("internalReplyMessage");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public DateTimeTimeZone getScheduledEndDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("scheduledEndDateTime");
    }

    @Nullable
    public DateTimeTimeZone getScheduledStartDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("scheduledStartDateTime");
    }

    @Nullable
    public AutomaticRepliesStatus getStatus() {
        return (AutomaticRepliesStatus)((Object)this.backingStore.get("status"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeEnumValue("externalAudience", (Enum)this.getExternalAudience());
        writer.writeStringValue("externalReplyMessage", this.getExternalReplyMessage());
        writer.writeStringValue("internalReplyMessage", this.getInternalReplyMessage());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("scheduledEndDateTime", (Parsable)this.getScheduledEndDateTime(), new Parsable[0]);
        writer.writeObjectValue("scheduledStartDateTime", (Parsable)this.getScheduledStartDateTime(), new Parsable[0]);
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setExternalAudience(@Nullable ExternalAudienceScope value) {
        this.backingStore.set("externalAudience", (Object)value);
    }

    public void setExternalReplyMessage(@Nullable String value) {
        this.backingStore.set("externalReplyMessage", (Object)value);
    }

    public void setInternalReplyMessage(@Nullable String value) {
        this.backingStore.set("internalReplyMessage", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setScheduledEndDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("scheduledEndDateTime", (Object)value);
    }

    public void setScheduledStartDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("scheduledStartDateTime", (Object)value);
    }

    public void setStatus(@Nullable AutomaticRepliesStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

