/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.applications.item.synchronization.secrets;

import com.microsoft.graph.applications.item.synchronization.secrets.SecretsPutRequestBody;
import com.microsoft.graph.applications.item.synchronization.secrets.SecretsPutResponse;
import com.microsoft.graph.applications.item.synchronization.secrets.count.CountRequestBuilder;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SecretsRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public CountRequestBuilder count() {
        return new CountRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public SecretsRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/applications/{application%2Did}/synchronization/secrets", pathParameters);
    }

    public SecretsRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/applications/{application%2Did}/synchronization/secrets", rawUrl);
    }

    @Nullable
    public SecretsPutResponse put(@Nonnull SecretsPutRequestBody body) {
        return this.put(body, null);
    }

    @Nullable
    public SecretsPutResponse put(@Nonnull SecretsPutRequestBody body, @Nullable Consumer<PutRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPutRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (SecretsPutResponse)this.requestAdapter.send(requestInfo, errorMapping, SecretsPutResponse::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toPutRequestInformation(@Nonnull SecretsPutRequestBody body) {
        return this.toPutRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPutRequestInformation(@Nonnull SecretsPutRequestBody body, @Nullable Consumer<PutRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PUT, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PutRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public SecretsRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new SecretsRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PutRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

