package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
/**
 * Malware state for a windows device
 */
@jakarta.annotation.Generated("com.microsoft.kiota")
public class MalwareStateForWindowsDevice extends Entity implements Parsable {
    /**
     * Instantiates a new {@link MalwareStateForWindowsDevice} and sets the default values.
     */
    public MalwareStateForWindowsDevice() {
        super();
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a {@link MalwareStateForWindowsDevice}
     */
    @jakarta.annotation.Nonnull
    public static MalwareStateForWindowsDevice createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new MalwareStateForWindowsDevice();
    }
    /**
     * Gets the detectionCount property value. Indicates the number of times the malware is detected
     * @return a {@link Integer}
     */
    @jakarta.annotation.Nullable
    public Integer getDetectionCount() {
        return this.backingStore.get("detectionCount");
    }
    /**
     * Gets the deviceName property value. Indicates the name of the device being evaluated for malware state
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getDeviceName() {
        return this.backingStore.get("deviceName");
    }
    /**
     * Gets the executionState property value. Indicates execution status of the malware. The possible values are: unknown, blocked, allowed, running, notRunning. Defaults to unknown. The possible values are: unknown, blocked, allowed, running, notRunning.
     * @return a {@link WindowsMalwareExecutionState}
     */
    @jakarta.annotation.Nullable
    public WindowsMalwareExecutionState getExecutionState() {
        return this.backingStore.get("executionState");
    }
    /**
     * The deserialization information for the current model
     * @return a {@link Map<String, java.util.function.Consumer<ParseNode>>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("detectionCount", (n) -> { this.setDetectionCount(n.getIntegerValue()); });
        deserializerMap.put("deviceName", (n) -> { this.setDeviceName(n.getStringValue()); });
        deserializerMap.put("executionState", (n) -> { this.setExecutionState(n.getEnumValue(WindowsMalwareExecutionState::forValue)); });
        deserializerMap.put("initialDetectionDateTime", (n) -> { this.setInitialDetectionDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("lastStateChangeDateTime", (n) -> { this.setLastStateChangeDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("threatState", (n) -> { this.setThreatState(n.getEnumValue(WindowsMalwareThreatState::forValue)); });
        return deserializerMap;
    }
    /**
     * Gets the initialDetectionDateTime property value. Initial detection datetime of the malware
     * @return a {@link OffsetDateTime}
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getInitialDetectionDateTime() {
        return this.backingStore.get("initialDetectionDateTime");
    }
    /**
     * Gets the lastStateChangeDateTime property value. The last time this particular threat was changed
     * @return a {@link OffsetDateTime}
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getLastStateChangeDateTime() {
        return this.backingStore.get("lastStateChangeDateTime");
    }
    /**
     * Gets the threatState property value. Indicates threat status of the malware. The possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared. defaults to noStatusCleared. The possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
     * @return a {@link WindowsMalwareThreatState}
     */
    @jakarta.annotation.Nullable
    public WindowsMalwareThreatState getThreatState() {
        return this.backingStore.get("threatState");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeIntegerValue("detectionCount", this.getDetectionCount());
        writer.writeStringValue("deviceName", this.getDeviceName());
        writer.writeEnumValue("executionState", this.getExecutionState());
        writer.writeOffsetDateTimeValue("initialDetectionDateTime", this.getInitialDetectionDateTime());
        writer.writeOffsetDateTimeValue("lastStateChangeDateTime", this.getLastStateChangeDateTime());
        writer.writeEnumValue("threatState", this.getThreatState());
    }
    /**
     * Sets the detectionCount property value. Indicates the number of times the malware is detected
     * @param value Value to set for the detectionCount property.
     */
    public void setDetectionCount(@jakarta.annotation.Nullable final Integer value) {
        this.backingStore.set("detectionCount", value);
    }
    /**
     * Sets the deviceName property value. Indicates the name of the device being evaluated for malware state
     * @param value Value to set for the deviceName property.
     */
    public void setDeviceName(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("deviceName", value);
    }
    /**
     * Sets the executionState property value. Indicates execution status of the malware. The possible values are: unknown, blocked, allowed, running, notRunning. Defaults to unknown. The possible values are: unknown, blocked, allowed, running, notRunning.
     * @param value Value to set for the executionState property.
     */
    public void setExecutionState(@jakarta.annotation.Nullable final WindowsMalwareExecutionState value) {
        this.backingStore.set("executionState", value);
    }
    /**
     * Sets the initialDetectionDateTime property value. Initial detection datetime of the malware
     * @param value Value to set for the initialDetectionDateTime property.
     */
    public void setInitialDetectionDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("initialDetectionDateTime", value);
    }
    /**
     * Sets the lastStateChangeDateTime property value. The last time this particular threat was changed
     * @param value Value to set for the lastStateChangeDateTime property.
     */
    public void setLastStateChangeDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("lastStateChangeDateTime", value);
    }
    /**
     * Sets the threatState property value. Indicates threat status of the malware. The possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared. defaults to noStatusCleared. The possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
     * @param value Value to set for the threatState property.
     */
    public void setThreatState(@jakarta.annotation.Nullable final WindowsMalwareThreatState value) {
        this.backingStore.set("threatState", value);
    }
}
