/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security;

import com.microsoft.graph.models.Security;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.security.alerts.AlertsRequestBuilder;
import com.microsoft.graph.security.alerts_v2.AlertsV2RequestBuilder;
import com.microsoft.graph.security.attacksimulation.AttackSimulationRequestBuilder;
import com.microsoft.graph.security.cases.CasesRequestBuilder;
import com.microsoft.graph.security.incidents.IncidentsRequestBuilder;
import com.microsoft.graph.security.microsoftgraphsecurityrunhuntingquery.MicrosoftGraphSecurityRunHuntingQueryRequestBuilder;
import com.microsoft.graph.security.securescorecontrolprofiles.SecureScoreControlProfilesRequestBuilder;
import com.microsoft.graph.security.securescores.SecureScoresRequestBuilder;
import com.microsoft.graph.security.subjectrightsrequests.SubjectRightsRequestsRequestBuilder;
import com.microsoft.graph.security.threatintelligence.ThreatIntelligenceRequestBuilder;
import com.microsoft.graph.security.triggers.TriggersRequestBuilder;
import com.microsoft.graph.security.triggertypes.TriggerTypesRequestBuilder;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SecurityRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public AlertsRequestBuilder alerts() {
        return new AlertsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public AlertsV2RequestBuilder alertsV2() {
        return new AlertsV2RequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public AttackSimulationRequestBuilder attackSimulation() {
        return new AttackSimulationRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CasesRequestBuilder cases() {
        return new CasesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public IncidentsRequestBuilder incidents() {
        return new IncidentsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public MicrosoftGraphSecurityRunHuntingQueryRequestBuilder microsoftGraphSecurityRunHuntingQuery() {
        return new MicrosoftGraphSecurityRunHuntingQueryRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SecureScoreControlProfilesRequestBuilder secureScoreControlProfiles() {
        return new SecureScoreControlProfilesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SecureScoresRequestBuilder secureScores() {
        return new SecureScoresRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SubjectRightsRequestsRequestBuilder subjectRightsRequests() {
        return new SubjectRightsRequestsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ThreatIntelligenceRequestBuilder threatIntelligence() {
        return new ThreatIntelligenceRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public TriggersRequestBuilder triggers() {
        return new TriggersRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public TriggerTypesRequestBuilder triggerTypes() {
        return new TriggerTypesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public SecurityRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/security{?%24expand,%24select}", pathParameters);
    }

    public SecurityRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/security{?%24expand,%24select}", rawUrl);
    }

    @Nullable
    public Security get() {
        return this.get(null);
    }

    @Nullable
    public Security get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (Security)this.requestAdapter.send(requestInfo, errorMapping, Security::createFromDiscriminatorValue);
    }

    @Nullable
    public Security patch(@Nonnull Security body) {
        return this.patch(body, null);
    }

    @Nullable
    public Security patch(@Nonnull Security body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (Security)this.requestAdapter.send(requestInfo, errorMapping, Security::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Security body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Security body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, "{+baseurl}/security", (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public SecurityRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new SecurityRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }
}

