/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.identitygovernance;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.identitygovernance.LifecycleWorkflowProcessingStatus;
import com.microsoft.graph.models.identitygovernance.TaskProcessingResult;
import com.microsoft.graph.models.identitygovernance.UserProcessingResult;
import com.microsoft.graph.models.identitygovernance.WorkflowExecutionType;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Run
extends Entity
implements Parsable {
    @Nonnull
    public static Run createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Run();
    }

    @Nullable
    public OffsetDateTime getCompletedDateTime() {
        return (OffsetDateTime)this.backingStore.get("completedDateTime");
    }

    @Nullable
    public Integer getFailedTasksCount() {
        return (Integer)this.backingStore.get("failedTasksCount");
    }

    @Nullable
    public Integer getFailedUsersCount() {
        return (Integer)this.backingStore.get("failedUsersCount");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("completedDateTime", n -> this.setCompletedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("failedTasksCount", n -> this.setFailedTasksCount(n.getIntegerValue()));
        deserializerMap.put("failedUsersCount", n -> this.setFailedUsersCount(n.getIntegerValue()));
        deserializerMap.put("lastUpdatedDateTime", n -> this.setLastUpdatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("processingStatus", n -> this.setProcessingStatus((LifecycleWorkflowProcessingStatus)n.getEnumValue(LifecycleWorkflowProcessingStatus::forValue)));
        deserializerMap.put("scheduledDateTime", n -> this.setScheduledDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("startedDateTime", n -> this.setStartedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("successfulUsersCount", n -> this.setSuccessfulUsersCount(n.getIntegerValue()));
        deserializerMap.put("taskProcessingResults", n -> this.setTaskProcessingResults(n.getCollectionOfObjectValues(TaskProcessingResult::createFromDiscriminatorValue)));
        deserializerMap.put("totalTasksCount", n -> this.setTotalTasksCount(n.getIntegerValue()));
        deserializerMap.put("totalUnprocessedTasksCount", n -> this.setTotalUnprocessedTasksCount(n.getIntegerValue()));
        deserializerMap.put("totalUsersCount", n -> this.setTotalUsersCount(n.getIntegerValue()));
        deserializerMap.put("userProcessingResults", n -> this.setUserProcessingResults(n.getCollectionOfObjectValues(UserProcessingResult::createFromDiscriminatorValue)));
        deserializerMap.put("workflowExecutionType", n -> this.setWorkflowExecutionType((WorkflowExecutionType)n.getEnumValue(WorkflowExecutionType::forValue)));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastUpdatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastUpdatedDateTime");
    }

    @Nullable
    public LifecycleWorkflowProcessingStatus getProcessingStatus() {
        return (LifecycleWorkflowProcessingStatus)((Object)this.backingStore.get("processingStatus"));
    }

    @Nullable
    public OffsetDateTime getScheduledDateTime() {
        return (OffsetDateTime)this.backingStore.get("scheduledDateTime");
    }

    @Nullable
    public OffsetDateTime getStartedDateTime() {
        return (OffsetDateTime)this.backingStore.get("startedDateTime");
    }

    @Nullable
    public Integer getSuccessfulUsersCount() {
        return (Integer)this.backingStore.get("successfulUsersCount");
    }

    @Nullable
    public List<TaskProcessingResult> getTaskProcessingResults() {
        return (List)this.backingStore.get("taskProcessingResults");
    }

    @Nullable
    public Integer getTotalTasksCount() {
        return (Integer)this.backingStore.get("totalTasksCount");
    }

    @Nullable
    public Integer getTotalUnprocessedTasksCount() {
        return (Integer)this.backingStore.get("totalUnprocessedTasksCount");
    }

    @Nullable
    public Integer getTotalUsersCount() {
        return (Integer)this.backingStore.get("totalUsersCount");
    }

    @Nullable
    public List<UserProcessingResult> getUserProcessingResults() {
        return (List)this.backingStore.get("userProcessingResults");
    }

    @Nullable
    public WorkflowExecutionType getWorkflowExecutionType() {
        return (WorkflowExecutionType)((Object)this.backingStore.get("workflowExecutionType"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("completedDateTime", this.getCompletedDateTime());
        writer.writeIntegerValue("failedTasksCount", this.getFailedTasksCount());
        writer.writeIntegerValue("failedUsersCount", this.getFailedUsersCount());
        writer.writeOffsetDateTimeValue("lastUpdatedDateTime", this.getLastUpdatedDateTime());
        writer.writeEnumValue("processingStatus", (Enum)this.getProcessingStatus());
        writer.writeOffsetDateTimeValue("scheduledDateTime", this.getScheduledDateTime());
        writer.writeOffsetDateTimeValue("startedDateTime", this.getStartedDateTime());
        writer.writeIntegerValue("successfulUsersCount", this.getSuccessfulUsersCount());
        writer.writeCollectionOfObjectValues("taskProcessingResults", this.getTaskProcessingResults());
        writer.writeIntegerValue("totalTasksCount", this.getTotalTasksCount());
        writer.writeIntegerValue("totalUnprocessedTasksCount", this.getTotalUnprocessedTasksCount());
        writer.writeIntegerValue("totalUsersCount", this.getTotalUsersCount());
        writer.writeCollectionOfObjectValues("userProcessingResults", this.getUserProcessingResults());
        writer.writeEnumValue("workflowExecutionType", (Enum)this.getWorkflowExecutionType());
    }

    public void setCompletedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("completedDateTime", (Object)value);
    }

    public void setFailedTasksCount(@Nullable Integer value) {
        this.backingStore.set("failedTasksCount", (Object)value);
    }

    public void setFailedUsersCount(@Nullable Integer value) {
        this.backingStore.set("failedUsersCount", (Object)value);
    }

    public void setLastUpdatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastUpdatedDateTime", (Object)value);
    }

    public void setProcessingStatus(@Nullable LifecycleWorkflowProcessingStatus value) {
        this.backingStore.set("processingStatus", (Object)value);
    }

    public void setScheduledDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("scheduledDateTime", (Object)value);
    }

    public void setStartedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("startedDateTime", (Object)value);
    }

    public void setSuccessfulUsersCount(@Nullable Integer value) {
        this.backingStore.set("successfulUsersCount", (Object)value);
    }

    public void setTaskProcessingResults(@Nullable List<TaskProcessingResult> value) {
        this.backingStore.set("taskProcessingResults", value);
    }

    public void setTotalTasksCount(@Nullable Integer value) {
        this.backingStore.set("totalTasksCount", (Object)value);
    }

    public void setTotalUnprocessedTasksCount(@Nullable Integer value) {
        this.backingStore.set("totalUnprocessedTasksCount", (Object)value);
    }

    public void setTotalUsersCount(@Nullable Integer value) {
        this.backingStore.set("totalUsersCount", (Object)value);
    }

    public void setUserProcessingResults(@Nullable List<UserProcessingResult> value) {
        this.backingStore.set("userProcessingResults", value);
    }

    public void setWorkflowExecutionType(@Nullable WorkflowExecutionType value) {
        this.backingStore.set("workflowExecutionType", (Object)value);
    }
}

