/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.TeleconferenceDeviceAudioQuality;
import com.microsoft.graph.models.TeleconferenceDeviceScreenSharingQuality;
import com.microsoft.graph.models.TeleconferenceDeviceVideoQuality;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TeleconferenceDeviceMediaQuality
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public TeleconferenceDeviceMediaQuality() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static TeleconferenceDeviceMediaQuality createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.teleconferenceDeviceAudioQuality": {
                    return new TeleconferenceDeviceAudioQuality();
                }
                case "#microsoft.graph.teleconferenceDeviceScreenSharingQuality": {
                    return new TeleconferenceDeviceScreenSharingQuality();
                }
                case "#microsoft.graph.teleconferenceDeviceVideoQuality": {
                    return new TeleconferenceDeviceVideoQuality();
                }
            }
        }
        return new TeleconferenceDeviceMediaQuality();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public PeriodAndDuration getAverageInboundJitter() {
        return (PeriodAndDuration)this.backingStore.get("averageInboundJitter");
    }

    @Nullable
    public Double getAverageInboundPacketLossRateInPercentage() {
        return (Double)this.backingStore.get("averageInboundPacketLossRateInPercentage");
    }

    @Nullable
    public PeriodAndDuration getAverageInboundRoundTripDelay() {
        return (PeriodAndDuration)this.backingStore.get("averageInboundRoundTripDelay");
    }

    @Nullable
    public PeriodAndDuration getAverageOutboundJitter() {
        return (PeriodAndDuration)this.backingStore.get("averageOutboundJitter");
    }

    @Nullable
    public Double getAverageOutboundPacketLossRateInPercentage() {
        return (Double)this.backingStore.get("averageOutboundPacketLossRateInPercentage");
    }

    @Nullable
    public PeriodAndDuration getAverageOutboundRoundTripDelay() {
        return (PeriodAndDuration)this.backingStore.get("averageOutboundRoundTripDelay");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Integer getChannelIndex() {
        return (Integer)this.backingStore.get("channelIndex");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(22);
        deserializerMap.put("averageInboundJitter", n -> this.setAverageInboundJitter(n.getPeriodAndDurationValue()));
        deserializerMap.put("averageInboundPacketLossRateInPercentage", n -> this.setAverageInboundPacketLossRateInPercentage(n.getDoubleValue()));
        deserializerMap.put("averageInboundRoundTripDelay", n -> this.setAverageInboundRoundTripDelay(n.getPeriodAndDurationValue()));
        deserializerMap.put("averageOutboundJitter", n -> this.setAverageOutboundJitter(n.getPeriodAndDurationValue()));
        deserializerMap.put("averageOutboundPacketLossRateInPercentage", n -> this.setAverageOutboundPacketLossRateInPercentage(n.getDoubleValue()));
        deserializerMap.put("averageOutboundRoundTripDelay", n -> this.setAverageOutboundRoundTripDelay(n.getPeriodAndDurationValue()));
        deserializerMap.put("channelIndex", n -> this.setChannelIndex(n.getIntegerValue()));
        deserializerMap.put("inboundPackets", n -> this.setInboundPackets(n.getLongValue()));
        deserializerMap.put("localIPAddress", n -> this.setLocalIPAddress(n.getStringValue()));
        deserializerMap.put("localPort", n -> this.setLocalPort(n.getIntegerValue()));
        deserializerMap.put("maximumInboundJitter", n -> this.setMaximumInboundJitter(n.getPeriodAndDurationValue()));
        deserializerMap.put("maximumInboundPacketLossRateInPercentage", n -> this.setMaximumInboundPacketLossRateInPercentage(n.getDoubleValue()));
        deserializerMap.put("maximumInboundRoundTripDelay", n -> this.setMaximumInboundRoundTripDelay(n.getPeriodAndDurationValue()));
        deserializerMap.put("maximumOutboundJitter", n -> this.setMaximumOutboundJitter(n.getPeriodAndDurationValue()));
        deserializerMap.put("maximumOutboundPacketLossRateInPercentage", n -> this.setMaximumOutboundPacketLossRateInPercentage(n.getDoubleValue()));
        deserializerMap.put("maximumOutboundRoundTripDelay", n -> this.setMaximumOutboundRoundTripDelay(n.getPeriodAndDurationValue()));
        deserializerMap.put("mediaDuration", n -> this.setMediaDuration(n.getPeriodAndDurationValue()));
        deserializerMap.put("networkLinkSpeedInBytes", n -> this.setNetworkLinkSpeedInBytes(n.getLongValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("outboundPackets", n -> this.setOutboundPackets(n.getLongValue()));
        deserializerMap.put("remoteIPAddress", n -> this.setRemoteIPAddress(n.getStringValue()));
        deserializerMap.put("remotePort", n -> this.setRemotePort(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public Long getInboundPackets() {
        return (Long)this.backingStore.get("inboundPackets");
    }

    @Nullable
    public String getLocalIPAddress() {
        return (String)this.backingStore.get("localIPAddress");
    }

    @Nullable
    public Integer getLocalPort() {
        return (Integer)this.backingStore.get("localPort");
    }

    @Nullable
    public PeriodAndDuration getMaximumInboundJitter() {
        return (PeriodAndDuration)this.backingStore.get("maximumInboundJitter");
    }

    @Nullable
    public Double getMaximumInboundPacketLossRateInPercentage() {
        return (Double)this.backingStore.get("maximumInboundPacketLossRateInPercentage");
    }

    @Nullable
    public PeriodAndDuration getMaximumInboundRoundTripDelay() {
        return (PeriodAndDuration)this.backingStore.get("maximumInboundRoundTripDelay");
    }

    @Nullable
    public PeriodAndDuration getMaximumOutboundJitter() {
        return (PeriodAndDuration)this.backingStore.get("maximumOutboundJitter");
    }

    @Nullable
    public Double getMaximumOutboundPacketLossRateInPercentage() {
        return (Double)this.backingStore.get("maximumOutboundPacketLossRateInPercentage");
    }

    @Nullable
    public PeriodAndDuration getMaximumOutboundRoundTripDelay() {
        return (PeriodAndDuration)this.backingStore.get("maximumOutboundRoundTripDelay");
    }

    @Nullable
    public PeriodAndDuration getMediaDuration() {
        return (PeriodAndDuration)this.backingStore.get("mediaDuration");
    }

    @Nullable
    public Long getNetworkLinkSpeedInBytes() {
        return (Long)this.backingStore.get("networkLinkSpeedInBytes");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Long getOutboundPackets() {
        return (Long)this.backingStore.get("outboundPackets");
    }

    @Nullable
    public String getRemoteIPAddress() {
        return (String)this.backingStore.get("remoteIPAddress");
    }

    @Nullable
    public Integer getRemotePort() {
        return (Integer)this.backingStore.get("remotePort");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writePeriodAndDurationValue("averageInboundJitter", this.getAverageInboundJitter());
        writer.writeDoubleValue("averageInboundPacketLossRateInPercentage", this.getAverageInboundPacketLossRateInPercentage());
        writer.writePeriodAndDurationValue("averageInboundRoundTripDelay", this.getAverageInboundRoundTripDelay());
        writer.writePeriodAndDurationValue("averageOutboundJitter", this.getAverageOutboundJitter());
        writer.writeDoubleValue("averageOutboundPacketLossRateInPercentage", this.getAverageOutboundPacketLossRateInPercentage());
        writer.writePeriodAndDurationValue("averageOutboundRoundTripDelay", this.getAverageOutboundRoundTripDelay());
        writer.writeIntegerValue("channelIndex", this.getChannelIndex());
        writer.writeLongValue("inboundPackets", this.getInboundPackets());
        writer.writeStringValue("localIPAddress", this.getLocalIPAddress());
        writer.writeIntegerValue("localPort", this.getLocalPort());
        writer.writePeriodAndDurationValue("maximumInboundJitter", this.getMaximumInboundJitter());
        writer.writeDoubleValue("maximumInboundPacketLossRateInPercentage", this.getMaximumInboundPacketLossRateInPercentage());
        writer.writePeriodAndDurationValue("maximumInboundRoundTripDelay", this.getMaximumInboundRoundTripDelay());
        writer.writePeriodAndDurationValue("maximumOutboundJitter", this.getMaximumOutboundJitter());
        writer.writeDoubleValue("maximumOutboundPacketLossRateInPercentage", this.getMaximumOutboundPacketLossRateInPercentage());
        writer.writePeriodAndDurationValue("maximumOutboundRoundTripDelay", this.getMaximumOutboundRoundTripDelay());
        writer.writePeriodAndDurationValue("mediaDuration", this.getMediaDuration());
        writer.writeLongValue("networkLinkSpeedInBytes", this.getNetworkLinkSpeedInBytes());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeLongValue("outboundPackets", this.getOutboundPackets());
        writer.writeStringValue("remoteIPAddress", this.getRemoteIPAddress());
        writer.writeIntegerValue("remotePort", this.getRemotePort());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAverageInboundJitter(@Nullable PeriodAndDuration value) {
        this.backingStore.set("averageInboundJitter", (Object)value);
    }

    public void setAverageInboundPacketLossRateInPercentage(@Nullable Double value) {
        this.backingStore.set("averageInboundPacketLossRateInPercentage", (Object)value);
    }

    public void setAverageInboundRoundTripDelay(@Nullable PeriodAndDuration value) {
        this.backingStore.set("averageInboundRoundTripDelay", (Object)value);
    }

    public void setAverageOutboundJitter(@Nullable PeriodAndDuration value) {
        this.backingStore.set("averageOutboundJitter", (Object)value);
    }

    public void setAverageOutboundPacketLossRateInPercentage(@Nullable Double value) {
        this.backingStore.set("averageOutboundPacketLossRateInPercentage", (Object)value);
    }

    public void setAverageOutboundRoundTripDelay(@Nullable PeriodAndDuration value) {
        this.backingStore.set("averageOutboundRoundTripDelay", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setChannelIndex(@Nullable Integer value) {
        this.backingStore.set("channelIndex", (Object)value);
    }

    public void setInboundPackets(@Nullable Long value) {
        this.backingStore.set("inboundPackets", (Object)value);
    }

    public void setLocalIPAddress(@Nullable String value) {
        this.backingStore.set("localIPAddress", (Object)value);
    }

    public void setLocalPort(@Nullable Integer value) {
        this.backingStore.set("localPort", (Object)value);
    }

    public void setMaximumInboundJitter(@Nullable PeriodAndDuration value) {
        this.backingStore.set("maximumInboundJitter", (Object)value);
    }

    public void setMaximumInboundPacketLossRateInPercentage(@Nullable Double value) {
        this.backingStore.set("maximumInboundPacketLossRateInPercentage", (Object)value);
    }

    public void setMaximumInboundRoundTripDelay(@Nullable PeriodAndDuration value) {
        this.backingStore.set("maximumInboundRoundTripDelay", (Object)value);
    }

    public void setMaximumOutboundJitter(@Nullable PeriodAndDuration value) {
        this.backingStore.set("maximumOutboundJitter", (Object)value);
    }

    public void setMaximumOutboundPacketLossRateInPercentage(@Nullable Double value) {
        this.backingStore.set("maximumOutboundPacketLossRateInPercentage", (Object)value);
    }

    public void setMaximumOutboundRoundTripDelay(@Nullable PeriodAndDuration value) {
        this.backingStore.set("maximumOutboundRoundTripDelay", (Object)value);
    }

    public void setMediaDuration(@Nullable PeriodAndDuration value) {
        this.backingStore.set("mediaDuration", (Object)value);
    }

    public void setNetworkLinkSpeedInBytes(@Nullable Long value) {
        this.backingStore.set("networkLinkSpeedInBytes", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOutboundPackets(@Nullable Long value) {
        this.backingStore.set("outboundPackets", (Object)value);
    }

    public void setRemoteIPAddress(@Nullable String value) {
        this.backingStore.set("remoteIPAddress", (Object)value);
    }

    public void setRemotePort(@Nullable Integer value) {
        this.backingStore.set("remotePort", (Object)value);
    }
}

