/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TeamMessagingSettings
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public TeamMessagingSettings() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static TeamMessagingSettings createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new TeamMessagingSettings();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public Boolean getAllowChannelMentions() {
        return (Boolean)this.backingStore.get("allowChannelMentions");
    }

    @Nullable
    public Boolean getAllowOwnerDeleteMessages() {
        return (Boolean)this.backingStore.get("allowOwnerDeleteMessages");
    }

    @Nullable
    public Boolean getAllowTeamMentions() {
        return (Boolean)this.backingStore.get("allowTeamMentions");
    }

    @Nullable
    public Boolean getAllowUserDeleteMessages() {
        return (Boolean)this.backingStore.get("allowUserDeleteMessages");
    }

    @Nullable
    public Boolean getAllowUserEditMessages() {
        return (Boolean)this.backingStore.get("allowUserEditMessages");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("allowChannelMentions", n -> this.setAllowChannelMentions(n.getBooleanValue()));
        deserializerMap.put("allowOwnerDeleteMessages", n -> this.setAllowOwnerDeleteMessages(n.getBooleanValue()));
        deserializerMap.put("allowTeamMentions", n -> this.setAllowTeamMentions(n.getBooleanValue()));
        deserializerMap.put("allowUserDeleteMessages", n -> this.setAllowUserDeleteMessages(n.getBooleanValue()));
        deserializerMap.put("allowUserEditMessages", n -> this.setAllowUserEditMessages(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("allowChannelMentions", this.getAllowChannelMentions());
        writer.writeBooleanValue("allowOwnerDeleteMessages", this.getAllowOwnerDeleteMessages());
        writer.writeBooleanValue("allowTeamMentions", this.getAllowTeamMentions());
        writer.writeBooleanValue("allowUserDeleteMessages", this.getAllowUserDeleteMessages());
        writer.writeBooleanValue("allowUserEditMessages", this.getAllowUserEditMessages());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAllowChannelMentions(@Nullable Boolean value) {
        this.backingStore.set("allowChannelMentions", (Object)value);
    }

    public void setAllowOwnerDeleteMessages(@Nullable Boolean value) {
        this.backingStore.set("allowOwnerDeleteMessages", (Object)value);
    }

    public void setAllowTeamMentions(@Nullable Boolean value) {
        this.backingStore.set("allowTeamMentions", (Object)value);
    }

    public void setAllowUserDeleteMessages(@Nullable Boolean value) {
        this.backingStore.set("allowUserDeleteMessages", (Object)value);
    }

    public void setAllowUserEditMessages(@Nullable Boolean value) {
        this.backingStore.set("allowUserEditMessages", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }
}

