/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AndroidManagedAppProtection;
import com.microsoft.graph.models.IosManagedAppProtection;
import com.microsoft.graph.models.ManagedAppProtection;
import com.microsoft.graph.models.TargetedManagedAppPolicyAssignment;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TargetedManagedAppProtection
extends ManagedAppProtection
implements Parsable {
    public TargetedManagedAppProtection() {
        this.setOdataType("#microsoft.graph.targetedManagedAppProtection");
    }

    @Nonnull
    public static TargetedManagedAppProtection createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.androidManagedAppProtection": {
                    return new AndroidManagedAppProtection();
                }
                case "#microsoft.graph.iosManagedAppProtection": {
                    return new IosManagedAppProtection();
                }
            }
        }
        return new TargetedManagedAppProtection();
    }

    @Nullable
    public List<TargetedManagedAppPolicyAssignment> getAssignments() {
        return (List)this.backingStore.get("assignments");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("assignments", n -> this.setAssignments(n.getCollectionOfObjectValues(TargetedManagedAppPolicyAssignment::createFromDiscriminatorValue)));
        deserializerMap.put("isAssigned", n -> this.setIsAssigned(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsAssigned() {
        return (Boolean)this.backingStore.get("isAssigned");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("assignments", this.getAssignments());
        writer.writeBooleanValue("isAssigned", this.getIsAssigned());
    }

    public void setAssignments(@Nullable List<TargetedManagedAppPolicyAssignment> value) {
        this.backingStore.set("assignments", value);
    }

    public void setIsAssigned(@Nullable Boolean value) {
        this.backingStore.set("isAssigned", (Object)value);
    }
}

