/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SignInActivity
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SignInActivity() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SignInActivity createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SignInActivity();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("lastNonInteractiveSignInDateTime", n -> this.setLastNonInteractiveSignInDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastNonInteractiveSignInRequestId", n -> this.setLastNonInteractiveSignInRequestId(n.getStringValue()));
        deserializerMap.put("lastSignInDateTime", n -> this.setLastSignInDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastSignInRequestId", n -> this.setLastSignInRequestId(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastNonInteractiveSignInDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastNonInteractiveSignInDateTime");
    }

    @Nullable
    public String getLastNonInteractiveSignInRequestId() {
        return (String)this.backingStore.get("lastNonInteractiveSignInRequestId");
    }

    @Nullable
    public OffsetDateTime getLastSignInDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastSignInDateTime");
    }

    @Nullable
    public String getLastSignInRequestId() {
        return (String)this.backingStore.get("lastSignInRequestId");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeOffsetDateTimeValue("lastNonInteractiveSignInDateTime", this.getLastNonInteractiveSignInDateTime());
        writer.writeStringValue("lastNonInteractiveSignInRequestId", this.getLastNonInteractiveSignInRequestId());
        writer.writeOffsetDateTimeValue("lastSignInDateTime", this.getLastSignInDateTime());
        writer.writeStringValue("lastSignInRequestId", this.getLastSignInRequestId());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setLastNonInteractiveSignInDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastNonInteractiveSignInDateTime", (Object)value);
    }

    public void setLastNonInteractiveSignInRequestId(@Nullable String value) {
        this.backingStore.set("lastNonInteractiveSignInRequestId", (Object)value);
    }

    public void setLastSignInDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastSignInDateTime", (Object)value);
    }

    public void setLastSignInRequestId(@Nullable String value) {
        this.backingStore.set("lastSignInRequestId", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }
}

