/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AuthenticationProtocol;
import com.microsoft.graph.models.IdentityProviderBase;
import com.microsoft.graph.models.InternalDomainFederation;
import com.microsoft.graph.models.SamlOrWsFedExternalDomainFederation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SamlOrWsFedProvider
extends IdentityProviderBase
implements Parsable {
    public SamlOrWsFedProvider() {
        this.setOdataType("#microsoft.graph.samlOrWsFedProvider");
    }

    @Nonnull
    public static SamlOrWsFedProvider createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.internalDomainFederation": {
                    return new InternalDomainFederation();
                }
                case "#microsoft.graph.samlOrWsFedExternalDomainFederation": {
                    return new SamlOrWsFedExternalDomainFederation();
                }
            }
        }
        return new SamlOrWsFedProvider();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("issuerUri", n -> this.setIssuerUri(n.getStringValue()));
        deserializerMap.put("metadataExchangeUri", n -> this.setMetadataExchangeUri(n.getStringValue()));
        deserializerMap.put("passiveSignInUri", n -> this.setPassiveSignInUri(n.getStringValue()));
        deserializerMap.put("preferredAuthenticationProtocol", n -> this.setPreferredAuthenticationProtocol((AuthenticationProtocol)n.getEnumValue(AuthenticationProtocol::forValue)));
        deserializerMap.put("signingCertificate", n -> this.setSigningCertificate(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getIssuerUri() {
        return (String)this.backingStore.get("issuerUri");
    }

    @Nullable
    public String getMetadataExchangeUri() {
        return (String)this.backingStore.get("metadataExchangeUri");
    }

    @Nullable
    public String getPassiveSignInUri() {
        return (String)this.backingStore.get("passiveSignInUri");
    }

    @Nullable
    public AuthenticationProtocol getPreferredAuthenticationProtocol() {
        return (AuthenticationProtocol)((Object)this.backingStore.get("preferredAuthenticationProtocol"));
    }

    @Nullable
    public String getSigningCertificate() {
        return (String)this.backingStore.get("signingCertificate");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("issuerUri", this.getIssuerUri());
        writer.writeStringValue("metadataExchangeUri", this.getMetadataExchangeUri());
        writer.writeStringValue("passiveSignInUri", this.getPassiveSignInUri());
        writer.writeEnumValue("preferredAuthenticationProtocol", (Enum)this.getPreferredAuthenticationProtocol());
        writer.writeStringValue("signingCertificate", this.getSigningCertificate());
    }

    public void setIssuerUri(@Nullable String value) {
        this.backingStore.set("issuerUri", (Object)value);
    }

    public void setMetadataExchangeUri(@Nullable String value) {
        this.backingStore.set("metadataExchangeUri", (Object)value);
    }

    public void setPassiveSignInUri(@Nullable String value) {
        this.backingStore.set("passiveSignInUri", (Object)value);
    }

    public void setPreferredAuthenticationProtocol(@Nullable AuthenticationProtocol value) {
        this.backingStore.set("preferredAuthenticationProtocol", (Object)value);
    }

    public void setSigningCertificate(@Nullable String value) {
        this.backingStore.set("signingCertificate", (Object)value);
    }
}

