/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.PrintJob;
import com.microsoft.graph.models.Printer;
import com.microsoft.graph.models.PrinterCapabilities;
import com.microsoft.graph.models.PrinterDefaults;
import com.microsoft.graph.models.PrinterLocation;
import com.microsoft.graph.models.PrinterShare;
import com.microsoft.graph.models.PrinterStatus;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PrinterBase
extends Entity
implements Parsable {
    @Nonnull
    public static PrinterBase createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.printer": {
                    return new Printer();
                }
                case "#microsoft.graph.printerShare": {
                    return new PrinterShare();
                }
            }
        }
        return new PrinterBase();
    }

    @Nullable
    public PrinterCapabilities getCapabilities() {
        return (PrinterCapabilities)this.backingStore.get("capabilities");
    }

    @Nullable
    public PrinterDefaults getDefaults() {
        return (PrinterDefaults)this.backingStore.get("defaults");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("capabilities", n -> this.setCapabilities((PrinterCapabilities)n.getObjectValue(PrinterCapabilities::createFromDiscriminatorValue)));
        deserializerMap.put("defaults", n -> this.setDefaults((PrinterDefaults)n.getObjectValue(PrinterDefaults::createFromDiscriminatorValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("isAcceptingJobs", n -> this.setIsAcceptingJobs(n.getBooleanValue()));
        deserializerMap.put("jobs", n -> this.setJobs(n.getCollectionOfObjectValues(PrintJob::createFromDiscriminatorValue)));
        deserializerMap.put("location", n -> this.setLocation((PrinterLocation)n.getObjectValue(PrinterLocation::createFromDiscriminatorValue)));
        deserializerMap.put("manufacturer", n -> this.setManufacturer(n.getStringValue()));
        deserializerMap.put("model", n -> this.setModel(n.getStringValue()));
        deserializerMap.put("status", n -> this.setStatus((PrinterStatus)n.getObjectValue(PrinterStatus::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsAcceptingJobs() {
        return (Boolean)this.backingStore.get("isAcceptingJobs");
    }

    @Nullable
    public List<PrintJob> getJobs() {
        return (List)this.backingStore.get("jobs");
    }

    @Nullable
    public PrinterLocation getLocation() {
        return (PrinterLocation)this.backingStore.get("location");
    }

    @Nullable
    public String getManufacturer() {
        return (String)this.backingStore.get("manufacturer");
    }

    @Nullable
    public String getModel() {
        return (String)this.backingStore.get("model");
    }

    @Nullable
    public PrinterStatus getStatus() {
        return (PrinterStatus)this.backingStore.get("status");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("capabilities", (Parsable)this.getCapabilities(), new Parsable[0]);
        writer.writeObjectValue("defaults", (Parsable)this.getDefaults(), new Parsable[0]);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeBooleanValue("isAcceptingJobs", this.getIsAcceptingJobs());
        writer.writeCollectionOfObjectValues("jobs", this.getJobs());
        writer.writeObjectValue("location", (Parsable)this.getLocation(), new Parsable[0]);
        writer.writeStringValue("manufacturer", this.getManufacturer());
        writer.writeStringValue("model", this.getModel());
        writer.writeObjectValue("status", (Parsable)this.getStatus(), new Parsable[0]);
    }

    public void setCapabilities(@Nullable PrinterCapabilities value) {
        this.backingStore.set("capabilities", (Object)value);
    }

    public void setDefaults(@Nullable PrinterDefaults value) {
        this.backingStore.set("defaults", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setIsAcceptingJobs(@Nullable Boolean value) {
        this.backingStore.set("isAcceptingJobs", (Object)value);
    }

    public void setJobs(@Nullable List<PrintJob> value) {
        this.backingStore.set("jobs", value);
    }

    public void setLocation(@Nullable PrinterLocation value) {
        this.backingStore.set("location", (Object)value);
    }

    public void setManufacturer(@Nullable String value) {
        this.backingStore.set("manufacturer", (Object)value);
    }

    public void setModel(@Nullable String value) {
        this.backingStore.set("model", (Object)value);
    }

    public void setStatus(@Nullable PrinterStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

