/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Attachment;
import com.microsoft.graph.models.Extension;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.MultiValueLegacyExtendedProperty;
import com.microsoft.graph.models.OutlookItem;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.models.SingleValueLegacyExtendedProperty;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Post
extends OutlookItem
implements Parsable {
    public Post() {
        this.setOdataType("#microsoft.graph.post");
    }

    @Nonnull
    public static Post createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Post();
    }

    @Nullable
    public List<Attachment> getAttachments() {
        return (List)this.backingStore.get("attachments");
    }

    @Nullable
    public ItemBody getBody() {
        return (ItemBody)this.backingStore.get("body");
    }

    @Nullable
    public String getConversationId() {
        return (String)this.backingStore.get("conversationId");
    }

    @Nullable
    public String getConversationThreadId() {
        return (String)this.backingStore.get("conversationThreadId");
    }

    @Nullable
    public List<Extension> getExtensions() {
        return (List)this.backingStore.get("extensions");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("attachments", n -> this.setAttachments(n.getCollectionOfObjectValues(Attachment::createFromDiscriminatorValue)));
        deserializerMap.put("body", n -> this.setBody((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("conversationId", n -> this.setConversationId(n.getStringValue()));
        deserializerMap.put("conversationThreadId", n -> this.setConversationThreadId(n.getStringValue()));
        deserializerMap.put("extensions", n -> this.setExtensions(n.getCollectionOfObjectValues(Extension::createFromDiscriminatorValue)));
        deserializerMap.put("from", n -> this.setFrom((Recipient)n.getObjectValue(Recipient::createFromDiscriminatorValue)));
        deserializerMap.put("hasAttachments", n -> this.setHasAttachments(n.getBooleanValue()));
        deserializerMap.put("inReplyTo", n -> this.setInReplyTo((Post)n.getObjectValue(Post::createFromDiscriminatorValue)));
        deserializerMap.put("multiValueExtendedProperties", n -> this.setMultiValueExtendedProperties(n.getCollectionOfObjectValues(MultiValueLegacyExtendedProperty::createFromDiscriminatorValue)));
        deserializerMap.put("newParticipants", n -> this.setNewParticipants(n.getCollectionOfObjectValues(Recipient::createFromDiscriminatorValue)));
        deserializerMap.put("receivedDateTime", n -> this.setReceivedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("sender", n -> this.setSender((Recipient)n.getObjectValue(Recipient::createFromDiscriminatorValue)));
        deserializerMap.put("singleValueExtendedProperties", n -> this.setSingleValueExtendedProperties(n.getCollectionOfObjectValues(SingleValueLegacyExtendedProperty::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Recipient getFrom() {
        return (Recipient)this.backingStore.get("from");
    }

    @Nullable
    public Boolean getHasAttachments() {
        return (Boolean)this.backingStore.get("hasAttachments");
    }

    @Nullable
    public Post getInReplyTo() {
        return (Post)this.backingStore.get("inReplyTo");
    }

    @Nullable
    public List<MultiValueLegacyExtendedProperty> getMultiValueExtendedProperties() {
        return (List)this.backingStore.get("multiValueExtendedProperties");
    }

    @Nullable
    public List<Recipient> getNewParticipants() {
        return (List)this.backingStore.get("newParticipants");
    }

    @Nullable
    public OffsetDateTime getReceivedDateTime() {
        return (OffsetDateTime)this.backingStore.get("receivedDateTime");
    }

    @Nullable
    public Recipient getSender() {
        return (Recipient)this.backingStore.get("sender");
    }

    @Nullable
    public List<SingleValueLegacyExtendedProperty> getSingleValueExtendedProperties() {
        return (List)this.backingStore.get("singleValueExtendedProperties");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("attachments", this.getAttachments());
        writer.writeObjectValue("body", (Parsable)this.getBody(), new Parsable[0]);
        writer.writeStringValue("conversationId", this.getConversationId());
        writer.writeStringValue("conversationThreadId", this.getConversationThreadId());
        writer.writeCollectionOfObjectValues("extensions", this.getExtensions());
        writer.writeObjectValue("from", (Parsable)this.getFrom(), new Parsable[0]);
        writer.writeBooleanValue("hasAttachments", this.getHasAttachments());
        writer.writeObjectValue("inReplyTo", (Parsable)this.getInReplyTo(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("multiValueExtendedProperties", this.getMultiValueExtendedProperties());
        writer.writeCollectionOfObjectValues("newParticipants", this.getNewParticipants());
        writer.writeOffsetDateTimeValue("receivedDateTime", this.getReceivedDateTime());
        writer.writeObjectValue("sender", (Parsable)this.getSender(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("singleValueExtendedProperties", this.getSingleValueExtendedProperties());
    }

    public void setAttachments(@Nullable List<Attachment> value) {
        this.backingStore.set("attachments", value);
    }

    public void setBody(@Nullable ItemBody value) {
        this.backingStore.set("body", (Object)value);
    }

    public void setConversationId(@Nullable String value) {
        this.backingStore.set("conversationId", (Object)value);
    }

    public void setConversationThreadId(@Nullable String value) {
        this.backingStore.set("conversationThreadId", (Object)value);
    }

    public void setExtensions(@Nullable List<Extension> value) {
        this.backingStore.set("extensions", value);
    }

    public void setFrom(@Nullable Recipient value) {
        this.backingStore.set("from", (Object)value);
    }

    public void setHasAttachments(@Nullable Boolean value) {
        this.backingStore.set("hasAttachments", (Object)value);
    }

    public void setInReplyTo(@Nullable Post value) {
        this.backingStore.set("inReplyTo", (Object)value);
    }

    public void setMultiValueExtendedProperties(@Nullable List<MultiValueLegacyExtendedProperty> value) {
        this.backingStore.set("multiValueExtendedProperties", value);
    }

    public void setNewParticipants(@Nullable List<Recipient> value) {
        this.backingStore.set("newParticipants", value);
    }

    public void setReceivedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("receivedDateTime", (Object)value);
    }

    public void setSender(@Nullable Recipient value) {
        this.backingStore.set("sender", (Object)value);
    }

    public void setSingleValueExtendedProperties(@Nullable List<SingleValueLegacyExtendedProperty> value) {
        this.backingStore.set("singleValueExtendedProperties", value);
    }
}

