/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AudioConferencing;
import com.microsoft.graph.models.ChatInfo;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.JoinMeetingIdSettings;
import com.microsoft.graph.models.LobbyBypassSettings;
import com.microsoft.graph.models.MeetingAttendanceReport;
import com.microsoft.graph.models.MeetingChatHistoryDefaultMode;
import com.microsoft.graph.models.MeetingChatMode;
import com.microsoft.graph.models.OnlineMeeting;
import com.microsoft.graph.models.OnlineMeetingPresenters;
import com.microsoft.graph.models.VirtualEventSession;
import com.microsoft.graph.models.WatermarkProtectionValues;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class OnlineMeetingBase
extends Entity
implements Parsable {
    @Nonnull
    public static OnlineMeetingBase createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.onlineMeeting": {
                    return new OnlineMeeting();
                }
                case "#microsoft.graph.virtualEventSession": {
                    return new VirtualEventSession();
                }
            }
        }
        return new OnlineMeetingBase();
    }

    @Nullable
    public Boolean getAllowAttendeeToEnableCamera() {
        return (Boolean)this.backingStore.get("allowAttendeeToEnableCamera");
    }

    @Nullable
    public Boolean getAllowAttendeeToEnableMic() {
        return (Boolean)this.backingStore.get("allowAttendeeToEnableMic");
    }

    @Nullable
    public OnlineMeetingPresenters getAllowedPresenters() {
        return (OnlineMeetingPresenters)((Object)this.backingStore.get("allowedPresenters"));
    }

    @Nullable
    public MeetingChatMode getAllowMeetingChat() {
        return (MeetingChatMode)((Object)this.backingStore.get("allowMeetingChat"));
    }

    @Nullable
    public Boolean getAllowParticipantsToChangeName() {
        return (Boolean)this.backingStore.get("allowParticipantsToChangeName");
    }

    @Nullable
    public Boolean getAllowTeamworkReactions() {
        return (Boolean)this.backingStore.get("allowTeamworkReactions");
    }

    @Nullable
    public List<MeetingAttendanceReport> getAttendanceReports() {
        return (List)this.backingStore.get("attendanceReports");
    }

    @Nullable
    public AudioConferencing getAudioConferencing() {
        return (AudioConferencing)this.backingStore.get("audioConferencing");
    }

    @Nullable
    public ChatInfo getChatInfo() {
        return (ChatInfo)this.backingStore.get("chatInfo");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("allowAttendeeToEnableCamera", n -> this.setAllowAttendeeToEnableCamera(n.getBooleanValue()));
        deserializerMap.put("allowAttendeeToEnableMic", n -> this.setAllowAttendeeToEnableMic(n.getBooleanValue()));
        deserializerMap.put("allowedPresenters", n -> this.setAllowedPresenters((OnlineMeetingPresenters)n.getEnumValue(OnlineMeetingPresenters::forValue)));
        deserializerMap.put("allowMeetingChat", n -> this.setAllowMeetingChat((MeetingChatMode)n.getEnumValue(MeetingChatMode::forValue)));
        deserializerMap.put("allowParticipantsToChangeName", n -> this.setAllowParticipantsToChangeName(n.getBooleanValue()));
        deserializerMap.put("allowTeamworkReactions", n -> this.setAllowTeamworkReactions(n.getBooleanValue()));
        deserializerMap.put("attendanceReports", n -> this.setAttendanceReports(n.getCollectionOfObjectValues(MeetingAttendanceReport::createFromDiscriminatorValue)));
        deserializerMap.put("audioConferencing", n -> this.setAudioConferencing((AudioConferencing)n.getObjectValue(AudioConferencing::createFromDiscriminatorValue)));
        deserializerMap.put("chatInfo", n -> this.setChatInfo((ChatInfo)n.getObjectValue(ChatInfo::createFromDiscriminatorValue)));
        deserializerMap.put("isEntryExitAnnounced", n -> this.setIsEntryExitAnnounced(n.getBooleanValue()));
        deserializerMap.put("joinInformation", n -> this.setJoinInformation((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("joinMeetingIdSettings", n -> this.setJoinMeetingIdSettings((JoinMeetingIdSettings)n.getObjectValue(JoinMeetingIdSettings::createFromDiscriminatorValue)));
        deserializerMap.put("joinWebUrl", n -> this.setJoinWebUrl(n.getStringValue()));
        deserializerMap.put("lobbyBypassSettings", n -> this.setLobbyBypassSettings((LobbyBypassSettings)n.getObjectValue(LobbyBypassSettings::createFromDiscriminatorValue)));
        deserializerMap.put("recordAutomatically", n -> this.setRecordAutomatically(n.getBooleanValue()));
        deserializerMap.put("shareMeetingChatHistoryDefault", n -> this.setShareMeetingChatHistoryDefault((MeetingChatHistoryDefaultMode)n.getEnumValue(MeetingChatHistoryDefaultMode::forValue)));
        deserializerMap.put("subject", n -> this.setSubject(n.getStringValue()));
        deserializerMap.put("videoTeleconferenceId", n -> this.setVideoTeleconferenceId(n.getStringValue()));
        deserializerMap.put("watermarkProtection", n -> this.setWatermarkProtection((WatermarkProtectionValues)n.getObjectValue(WatermarkProtectionValues::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsEntryExitAnnounced() {
        return (Boolean)this.backingStore.get("isEntryExitAnnounced");
    }

    @Nullable
    public ItemBody getJoinInformation() {
        return (ItemBody)this.backingStore.get("joinInformation");
    }

    @Nullable
    public JoinMeetingIdSettings getJoinMeetingIdSettings() {
        return (JoinMeetingIdSettings)this.backingStore.get("joinMeetingIdSettings");
    }

    @Nullable
    public String getJoinWebUrl() {
        return (String)this.backingStore.get("joinWebUrl");
    }

    @Nullable
    public LobbyBypassSettings getLobbyBypassSettings() {
        return (LobbyBypassSettings)this.backingStore.get("lobbyBypassSettings");
    }

    @Nullable
    public Boolean getRecordAutomatically() {
        return (Boolean)this.backingStore.get("recordAutomatically");
    }

    @Nullable
    public MeetingChatHistoryDefaultMode getShareMeetingChatHistoryDefault() {
        return (MeetingChatHistoryDefaultMode)((Object)this.backingStore.get("shareMeetingChatHistoryDefault"));
    }

    @Nullable
    public String getSubject() {
        return (String)this.backingStore.get("subject");
    }

    @Nullable
    public String getVideoTeleconferenceId() {
        return (String)this.backingStore.get("videoTeleconferenceId");
    }

    @Nullable
    public WatermarkProtectionValues getWatermarkProtection() {
        return (WatermarkProtectionValues)this.backingStore.get("watermarkProtection");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeBooleanValue("allowAttendeeToEnableCamera", this.getAllowAttendeeToEnableCamera());
        writer.writeBooleanValue("allowAttendeeToEnableMic", this.getAllowAttendeeToEnableMic());
        writer.writeEnumValue("allowedPresenters", (Enum)this.getAllowedPresenters());
        writer.writeEnumValue("allowMeetingChat", (Enum)this.getAllowMeetingChat());
        writer.writeBooleanValue("allowParticipantsToChangeName", this.getAllowParticipantsToChangeName());
        writer.writeBooleanValue("allowTeamworkReactions", this.getAllowTeamworkReactions());
        writer.writeCollectionOfObjectValues("attendanceReports", this.getAttendanceReports());
        writer.writeObjectValue("audioConferencing", (Parsable)this.getAudioConferencing(), new Parsable[0]);
        writer.writeObjectValue("chatInfo", (Parsable)this.getChatInfo(), new Parsable[0]);
        writer.writeBooleanValue("isEntryExitAnnounced", this.getIsEntryExitAnnounced());
        writer.writeObjectValue("joinInformation", (Parsable)this.getJoinInformation(), new Parsable[0]);
        writer.writeObjectValue("joinMeetingIdSettings", (Parsable)this.getJoinMeetingIdSettings(), new Parsable[0]);
        writer.writeStringValue("joinWebUrl", this.getJoinWebUrl());
        writer.writeObjectValue("lobbyBypassSettings", (Parsable)this.getLobbyBypassSettings(), new Parsable[0]);
        writer.writeBooleanValue("recordAutomatically", this.getRecordAutomatically());
        writer.writeEnumValue("shareMeetingChatHistoryDefault", (Enum)this.getShareMeetingChatHistoryDefault());
        writer.writeStringValue("subject", this.getSubject());
        writer.writeStringValue("videoTeleconferenceId", this.getVideoTeleconferenceId());
        writer.writeObjectValue("watermarkProtection", (Parsable)this.getWatermarkProtection(), new Parsable[0]);
    }

    public void setAllowAttendeeToEnableCamera(@Nullable Boolean value) {
        this.backingStore.set("allowAttendeeToEnableCamera", (Object)value);
    }

    public void setAllowAttendeeToEnableMic(@Nullable Boolean value) {
        this.backingStore.set("allowAttendeeToEnableMic", (Object)value);
    }

    public void setAllowedPresenters(@Nullable OnlineMeetingPresenters value) {
        this.backingStore.set("allowedPresenters", (Object)value);
    }

    public void setAllowMeetingChat(@Nullable MeetingChatMode value) {
        this.backingStore.set("allowMeetingChat", (Object)value);
    }

    public void setAllowParticipantsToChangeName(@Nullable Boolean value) {
        this.backingStore.set("allowParticipantsToChangeName", (Object)value);
    }

    public void setAllowTeamworkReactions(@Nullable Boolean value) {
        this.backingStore.set("allowTeamworkReactions", (Object)value);
    }

    public void setAttendanceReports(@Nullable List<MeetingAttendanceReport> value) {
        this.backingStore.set("attendanceReports", value);
    }

    public void setAudioConferencing(@Nullable AudioConferencing value) {
        this.backingStore.set("audioConferencing", (Object)value);
    }

    public void setChatInfo(@Nullable ChatInfo value) {
        this.backingStore.set("chatInfo", (Object)value);
    }

    public void setIsEntryExitAnnounced(@Nullable Boolean value) {
        this.backingStore.set("isEntryExitAnnounced", (Object)value);
    }

    public void setJoinInformation(@Nullable ItemBody value) {
        this.backingStore.set("joinInformation", (Object)value);
    }

    public void setJoinMeetingIdSettings(@Nullable JoinMeetingIdSettings value) {
        this.backingStore.set("joinMeetingIdSettings", (Object)value);
    }

    public void setJoinWebUrl(@Nullable String value) {
        this.backingStore.set("joinWebUrl", (Object)value);
    }

    public void setLobbyBypassSettings(@Nullable LobbyBypassSettings value) {
        this.backingStore.set("lobbyBypassSettings", (Object)value);
    }

    public void setRecordAutomatically(@Nullable Boolean value) {
        this.backingStore.set("recordAutomatically", (Object)value);
    }

    public void setShareMeetingChatHistoryDefault(@Nullable MeetingChatHistoryDefaultMode value) {
        this.backingStore.set("shareMeetingChatHistoryDefault", (Object)value);
    }

    public void setSubject(@Nullable String value) {
        this.backingStore.set("subject", (Object)value);
    }

    public void setVideoTeleconferenceId(@Nullable String value) {
        this.backingStore.set("videoTeleconferenceId", (Object)value);
    }

    public void setWatermarkProtection(@Nullable WatermarkProtectionValues value) {
        this.backingStore.set("watermarkProtection", (Object)value);
    }
}

