/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AuthenticationMethod;
import com.microsoft.graph.models.Device;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MicrosoftAuthenticatorAuthenticationMethod
extends AuthenticationMethod
implements Parsable {
    public MicrosoftAuthenticatorAuthenticationMethod() {
        this.setOdataType("#microsoft.graph.microsoftAuthenticatorAuthenticationMethod");
    }

    @Nonnull
    public static MicrosoftAuthenticatorAuthenticationMethod createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new MicrosoftAuthenticatorAuthenticationMethod();
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public Device getDevice() {
        return (Device)this.backingStore.get("device");
    }

    @Nullable
    public String getDeviceTag() {
        return (String)this.backingStore.get("deviceTag");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("device", n -> this.setDevice((Device)n.getObjectValue(Device::createFromDiscriminatorValue)));
        deserializerMap.put("deviceTag", n -> this.setDeviceTag(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("phoneAppVersion", n -> this.setPhoneAppVersion(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getPhoneAppVersion() {
        return (String)this.backingStore.get("phoneAppVersion");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeObjectValue("device", (Parsable)this.getDevice(), new Parsable[0]);
        writer.writeStringValue("deviceTag", this.getDeviceTag());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("phoneAppVersion", this.getPhoneAppVersion());
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDevice(@Nullable Device value) {
        this.backingStore.set("device", (Object)value);
    }

    public void setDeviceTag(@Nullable String value) {
        this.backingStore.set("deviceTag", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setPhoneAppVersion(@Nullable String value) {
        this.backingStore.set("phoneAppVersion", (Object)value);
    }
}

