/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AttackSimulationOperation;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.LongRunningOperationStatus;
import com.microsoft.graph.models.RichLongRunningOperation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class LongRunningOperation
extends Entity
implements Parsable {
    @Nonnull
    public static LongRunningOperation createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.attackSimulationOperation": {
                    return new AttackSimulationOperation();
                }
                case "#microsoft.graph.richLongRunningOperation": {
                    return new RichLongRunningOperation();
                }
            }
        }
        return new LongRunningOperation();
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastActionDateTime", n -> this.setLastActionDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("resourceLocation", n -> this.setResourceLocation(n.getStringValue()));
        deserializerMap.put("status", n -> this.setStatus((LongRunningOperationStatus)n.getEnumValue(LongRunningOperationStatus::forValue)));
        deserializerMap.put("statusDetail", n -> this.setStatusDetail(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastActionDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastActionDateTime");
    }

    @Nullable
    public String getResourceLocation() {
        return (String)this.backingStore.get("resourceLocation");
    }

    @Nullable
    public LongRunningOperationStatus getStatus() {
        return (LongRunningOperationStatus)((Object)this.backingStore.get("status"));
    }

    @Nullable
    public String getStatusDetail() {
        return (String)this.backingStore.get("statusDetail");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeOffsetDateTimeValue("lastActionDateTime", this.getLastActionDateTime());
        writer.writeStringValue("resourceLocation", this.getResourceLocation());
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeStringValue("statusDetail", this.getStatusDetail());
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setLastActionDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastActionDateTime", (Object)value);
    }

    public void setResourceLocation(@Nullable String value) {
        this.backingStore.set("resourceLocation", (Object)value);
    }

    public void setStatus(@Nullable LongRunningOperationStatus value) {
        this.backingStore.set("status", (Object)value);
    }

    public void setStatusDetail(@Nullable String value) {
        this.backingStore.set("statusDetail", (Object)value);
    }
}

