/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.SharepointIds;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ItemReference
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ItemReference() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ItemReference createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ItemReference();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDriveId() {
        return (String)this.backingStore.get("driveId");
    }

    @Nullable
    public String getDriveType() {
        return (String)this.backingStore.get("driveType");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(9);
        deserializerMap.put("driveId", n -> this.setDriveId(n.getStringValue()));
        deserializerMap.put("driveType", n -> this.setDriveType(n.getStringValue()));
        deserializerMap.put("id", n -> this.setId(n.getStringValue()));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("path", n -> this.setPath(n.getStringValue()));
        deserializerMap.put("shareId", n -> this.setShareId(n.getStringValue()));
        deserializerMap.put("sharepointIds", n -> this.setSharepointIds((SharepointIds)n.getObjectValue(SharepointIds::createFromDiscriminatorValue)));
        deserializerMap.put("siteId", n -> this.setSiteId(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getId() {
        return (String)this.backingStore.get("id");
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getPath() {
        return (String)this.backingStore.get("path");
    }

    @Nullable
    public String getShareId() {
        return (String)this.backingStore.get("shareId");
    }

    @Nullable
    public SharepointIds getSharepointIds() {
        return (SharepointIds)this.backingStore.get("sharepointIds");
    }

    @Nullable
    public String getSiteId() {
        return (String)this.backingStore.get("siteId");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("driveId", this.getDriveId());
        writer.writeStringValue("driveType", this.getDriveType());
        writer.writeStringValue("id", this.getId());
        writer.writeStringValue("name", this.getName());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("path", this.getPath());
        writer.writeStringValue("shareId", this.getShareId());
        writer.writeObjectValue("sharepointIds", (Parsable)this.getSharepointIds(), new Parsable[0]);
        writer.writeStringValue("siteId", this.getSiteId());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDriveId(@Nullable String value) {
        this.backingStore.set("driveId", (Object)value);
    }

    public void setDriveType(@Nullable String value) {
        this.backingStore.set("driveType", (Object)value);
    }

    public void setId(@Nullable String value) {
        this.backingStore.set("id", (Object)value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPath(@Nullable String value) {
        this.backingStore.set("path", (Object)value);
    }

    public void setShareId(@Nullable String value) {
        this.backingStore.set("shareId", (Object)value);
    }

    public void setSharepointIds(@Nullable SharepointIds value) {
        this.backingStore.set("sharepointIds", (Object)value);
    }

    public void setSiteId(@Nullable String value) {
        this.backingStore.set("siteId", (Object)value);
    }
}

