/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AccessPackage;
import com.microsoft.graph.models.AccessPackageAssignment;
import com.microsoft.graph.models.AccessPackageAssignmentPolicy;
import com.microsoft.graph.models.AccessPackageAssignmentRequest;
import com.microsoft.graph.models.AccessPackageCatalog;
import com.microsoft.graph.models.AccessPackageResource;
import com.microsoft.graph.models.AccessPackageResourceEnvironment;
import com.microsoft.graph.models.AccessPackageResourceRequest;
import com.microsoft.graph.models.AccessPackageResourceRoleScope;
import com.microsoft.graph.models.Approval;
import com.microsoft.graph.models.ConnectedOrganization;
import com.microsoft.graph.models.EntitlementManagementSettings;
import com.microsoft.graph.models.Entity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EntitlementManagement
extends Entity
implements Parsable {
    @Nonnull
    public static EntitlementManagement createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new EntitlementManagement();
    }

    @Nullable
    public List<Approval> getAccessPackageAssignmentApprovals() {
        return (List)this.backingStore.get("accessPackageAssignmentApprovals");
    }

    @Nullable
    public List<AccessPackage> getAccessPackages() {
        return (List)this.backingStore.get("accessPackages");
    }

    @Nullable
    public List<AccessPackageAssignmentPolicy> getAssignmentPolicies() {
        return (List)this.backingStore.get("assignmentPolicies");
    }

    @Nullable
    public List<AccessPackageAssignmentRequest> getAssignmentRequests() {
        return (List)this.backingStore.get("assignmentRequests");
    }

    @Nullable
    public List<AccessPackageAssignment> getAssignments() {
        return (List)this.backingStore.get("assignments");
    }

    @Nullable
    public List<AccessPackageCatalog> getCatalogs() {
        return (List)this.backingStore.get("catalogs");
    }

    @Nullable
    public List<ConnectedOrganization> getConnectedOrganizations() {
        return (List)this.backingStore.get("connectedOrganizations");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("accessPackageAssignmentApprovals", n -> this.setAccessPackageAssignmentApprovals(n.getCollectionOfObjectValues(Approval::createFromDiscriminatorValue)));
        deserializerMap.put("accessPackages", n -> this.setAccessPackages(n.getCollectionOfObjectValues(AccessPackage::createFromDiscriminatorValue)));
        deserializerMap.put("assignmentPolicies", n -> this.setAssignmentPolicies(n.getCollectionOfObjectValues(AccessPackageAssignmentPolicy::createFromDiscriminatorValue)));
        deserializerMap.put("assignmentRequests", n -> this.setAssignmentRequests(n.getCollectionOfObjectValues(AccessPackageAssignmentRequest::createFromDiscriminatorValue)));
        deserializerMap.put("assignments", n -> this.setAssignments(n.getCollectionOfObjectValues(AccessPackageAssignment::createFromDiscriminatorValue)));
        deserializerMap.put("catalogs", n -> this.setCatalogs(n.getCollectionOfObjectValues(AccessPackageCatalog::createFromDiscriminatorValue)));
        deserializerMap.put("connectedOrganizations", n -> this.setConnectedOrganizations(n.getCollectionOfObjectValues(ConnectedOrganization::createFromDiscriminatorValue)));
        deserializerMap.put("resourceEnvironments", n -> this.setResourceEnvironments(n.getCollectionOfObjectValues(AccessPackageResourceEnvironment::createFromDiscriminatorValue)));
        deserializerMap.put("resourceRequests", n -> this.setResourceRequests(n.getCollectionOfObjectValues(AccessPackageResourceRequest::createFromDiscriminatorValue)));
        deserializerMap.put("resourceRoleScopes", n -> this.setResourceRoleScopes(n.getCollectionOfObjectValues(AccessPackageResourceRoleScope::createFromDiscriminatorValue)));
        deserializerMap.put("resources", n -> this.setResources(n.getCollectionOfObjectValues(AccessPackageResource::createFromDiscriminatorValue)));
        deserializerMap.put("settings", n -> this.setSettings((EntitlementManagementSettings)n.getObjectValue(EntitlementManagementSettings::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<AccessPackageResourceEnvironment> getResourceEnvironments() {
        return (List)this.backingStore.get("resourceEnvironments");
    }

    @Nullable
    public List<AccessPackageResourceRequest> getResourceRequests() {
        return (List)this.backingStore.get("resourceRequests");
    }

    @Nullable
    public List<AccessPackageResourceRoleScope> getResourceRoleScopes() {
        return (List)this.backingStore.get("resourceRoleScopes");
    }

    @Nullable
    public List<AccessPackageResource> getResources() {
        return (List)this.backingStore.get("resources");
    }

    @Nullable
    public EntitlementManagementSettings getSettings() {
        return (EntitlementManagementSettings)this.backingStore.get("settings");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("accessPackageAssignmentApprovals", this.getAccessPackageAssignmentApprovals());
        writer.writeCollectionOfObjectValues("accessPackages", this.getAccessPackages());
        writer.writeCollectionOfObjectValues("assignmentPolicies", this.getAssignmentPolicies());
        writer.writeCollectionOfObjectValues("assignmentRequests", this.getAssignmentRequests());
        writer.writeCollectionOfObjectValues("assignments", this.getAssignments());
        writer.writeCollectionOfObjectValues("catalogs", this.getCatalogs());
        writer.writeCollectionOfObjectValues("connectedOrganizations", this.getConnectedOrganizations());
        writer.writeCollectionOfObjectValues("resourceEnvironments", this.getResourceEnvironments());
        writer.writeCollectionOfObjectValues("resourceRequests", this.getResourceRequests());
        writer.writeCollectionOfObjectValues("resourceRoleScopes", this.getResourceRoleScopes());
        writer.writeCollectionOfObjectValues("resources", this.getResources());
        writer.writeObjectValue("settings", (Parsable)this.getSettings(), new Parsable[0]);
    }

    public void setAccessPackageAssignmentApprovals(@Nullable List<Approval> value) {
        this.backingStore.set("accessPackageAssignmentApprovals", value);
    }

    public void setAccessPackages(@Nullable List<AccessPackage> value) {
        this.backingStore.set("accessPackages", value);
    }

    public void setAssignmentPolicies(@Nullable List<AccessPackageAssignmentPolicy> value) {
        this.backingStore.set("assignmentPolicies", value);
    }

    public void setAssignmentRequests(@Nullable List<AccessPackageAssignmentRequest> value) {
        this.backingStore.set("assignmentRequests", value);
    }

    public void setAssignments(@Nullable List<AccessPackageAssignment> value) {
        this.backingStore.set("assignments", value);
    }

    public void setCatalogs(@Nullable List<AccessPackageCatalog> value) {
        this.backingStore.set("catalogs", value);
    }

    public void setConnectedOrganizations(@Nullable List<ConnectedOrganization> value) {
        this.backingStore.set("connectedOrganizations", value);
    }

    public void setResourceEnvironments(@Nullable List<AccessPackageResourceEnvironment> value) {
        this.backingStore.set("resourceEnvironments", value);
    }

    public void setResourceRequests(@Nullable List<AccessPackageResourceRequest> value) {
        this.backingStore.set("resourceRequests", value);
    }

    public void setResourceRoleScopes(@Nullable List<AccessPackageResourceRoleScope> value) {
        this.backingStore.set("resourceRoleScopes", value);
    }

    public void setResources(@Nullable List<AccessPackageResource> value) {
        this.backingStore.set("resources", value);
    }

    public void setSettings(@Nullable EntitlementManagementSettings value) {
        this.backingStore.set("settings", (Object)value);
    }
}

