/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ConnectedOrganizationState;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentitySource;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ConnectedOrganization
extends Entity
implements Parsable {
    @Nonnull
    public static ConnectedOrganization createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ConnectedOrganization();
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public List<DirectoryObject> getExternalSponsors() {
        return (List)this.backingStore.get("externalSponsors");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("externalSponsors", n -> this.setExternalSponsors(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("identitySources", n -> this.setIdentitySources(n.getCollectionOfObjectValues(IdentitySource::createFromDiscriminatorValue)));
        deserializerMap.put("internalSponsors", n -> this.setInternalSponsors(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("modifiedDateTime", n -> this.setModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("state", n -> this.setState((ConnectedOrganizationState)n.getEnumValue(ConnectedOrganizationState::forValue)));
        return deserializerMap;
    }

    @Nullable
    public List<IdentitySource> getIdentitySources() {
        return (List)this.backingStore.get("identitySources");
    }

    @Nullable
    public List<DirectoryObject> getInternalSponsors() {
        return (List)this.backingStore.get("internalSponsors");
    }

    @Nullable
    public OffsetDateTime getModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("modifiedDateTime");
    }

    @Nullable
    public ConnectedOrganizationState getState() {
        return (ConnectedOrganizationState)((Object)this.backingStore.get("state"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeCollectionOfObjectValues("externalSponsors", this.getExternalSponsors());
        writer.writeCollectionOfObjectValues("identitySources", this.getIdentitySources());
        writer.writeCollectionOfObjectValues("internalSponsors", this.getInternalSponsors());
        writer.writeOffsetDateTimeValue("modifiedDateTime", this.getModifiedDateTime());
        writer.writeEnumValue("state", (Enum)this.getState());
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setExternalSponsors(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("externalSponsors", value);
    }

    public void setIdentitySources(@Nullable List<IdentitySource> value) {
        this.backingStore.set("identitySources", value);
    }

    public void setInternalSponsors(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("internalSponsors", value);
    }

    public void setModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("modifiedDateTime", (Object)value);
    }

    public void setState(@Nullable ConnectedOrganizationState value) {
        this.backingStore.set("state", (Object)value);
    }
}

