/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AnswerInputType;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BookingQuestionAnswer
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public BookingQuestionAnswer() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static BookingQuestionAnswer createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new BookingQuestionAnswer();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public String getAnswer() {
        return (String)this.backingStore.get("answer");
    }

    @Nullable
    public AnswerInputType getAnswerInputType() {
        return (AnswerInputType)((Object)this.backingStore.get("answerInputType"));
    }

    @Nullable
    public List<String> getAnswerOptions() {
        return (List)this.backingStore.get("answerOptions");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("answer", n -> this.setAnswer(n.getStringValue()));
        deserializerMap.put("answerInputType", n -> this.setAnswerInputType((AnswerInputType)n.getEnumValue(AnswerInputType::forValue)));
        deserializerMap.put("answerOptions", n -> this.setAnswerOptions(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("isRequired", n -> this.setIsRequired(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("question", n -> this.setQuestion(n.getStringValue()));
        deserializerMap.put("questionId", n -> this.setQuestionId(n.getStringValue()));
        deserializerMap.put("selectedOptions", n -> this.setSelectedOptions(n.getCollectionOfPrimitiveValues(String.class)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsRequired() {
        return (Boolean)this.backingStore.get("isRequired");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getQuestion() {
        return (String)this.backingStore.get("question");
    }

    @Nullable
    public String getQuestionId() {
        return (String)this.backingStore.get("questionId");
    }

    @Nullable
    public List<String> getSelectedOptions() {
        return (List)this.backingStore.get("selectedOptions");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("answer", this.getAnswer());
        writer.writeEnumValue("answerInputType", (Enum)this.getAnswerInputType());
        writer.writeCollectionOfPrimitiveValues("answerOptions", this.getAnswerOptions());
        writer.writeBooleanValue("isRequired", this.getIsRequired());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("question", this.getQuestion());
        writer.writeStringValue("questionId", this.getQuestionId());
        writer.writeCollectionOfPrimitiveValues("selectedOptions", this.getSelectedOptions());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAnswer(@Nullable String value) {
        this.backingStore.set("answer", (Object)value);
    }

    public void setAnswerInputType(@Nullable AnswerInputType value) {
        this.backingStore.set("answerInputType", (Object)value);
    }

    public void setAnswerOptions(@Nullable List<String> value) {
        this.backingStore.set("answerOptions", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setIsRequired(@Nullable Boolean value) {
        this.backingStore.set("isRequired", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setQuestion(@Nullable String value) {
        this.backingStore.set("question", (Object)value);
    }

    public void setQuestionId(@Nullable String value) {
        this.backingStore.set("questionId", (Object)value);
    }

    public void setSelectedOptions(@Nullable List<String> value) {
        this.backingStore.set("selectedOptions", value);
    }
}

