/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.EndUserNotification;
import com.microsoft.graph.models.PositiveReinforcementNotification;
import com.microsoft.graph.models.SimulationNotification;
import com.microsoft.graph.models.TrainingReminderNotification;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BaseEndUserNotification
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public BaseEndUserNotification() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static BaseEndUserNotification createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.positiveReinforcementNotification": {
                    return new PositiveReinforcementNotification();
                }
                case "#microsoft.graph.simulationNotification": {
                    return new SimulationNotification();
                }
                case "#microsoft.graph.trainingReminderNotification": {
                    return new TrainingReminderNotification();
                }
            }
        }
        return new BaseEndUserNotification();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDefaultLanguage() {
        return (String)this.backingStore.get("defaultLanguage");
    }

    @Nullable
    public EndUserNotification getEndUserNotification() {
        return (EndUserNotification)this.backingStore.get("endUserNotification");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(3);
        deserializerMap.put("defaultLanguage", n -> this.setDefaultLanguage(n.getStringValue()));
        deserializerMap.put("endUserNotification", n -> this.setEndUserNotification((EndUserNotification)n.getObjectValue(EndUserNotification::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("defaultLanguage", this.getDefaultLanguage());
        writer.writeObjectValue("endUserNotification", (Parsable)this.getEndUserNotification(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDefaultLanguage(@Nullable String value) {
        this.backingStore.set("defaultLanguage", (Object)value);
    }

    public void setEndUserNotification(@Nullable EndUserNotification value) {
        this.backingStore.set("endUserNotification", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }
}

