/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.PermissionScope;
import com.microsoft.graph.models.PreAuthorizedApplication;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;

public class ApiApplication
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ApiApplication() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ApiApplication createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ApiApplication();
    }

    @Nullable
    public Boolean getAcceptMappedClaims() {
        return (Boolean)this.backingStore.get("acceptMappedClaims");
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("acceptMappedClaims", n -> this.setAcceptMappedClaims(n.getBooleanValue()));
        deserializerMap.put("knownClientApplications", n -> this.setKnownClientApplications(n.getCollectionOfPrimitiveValues(UUID.class)));
        deserializerMap.put("oauth2PermissionScopes", n -> this.setOauth2PermissionScopes(n.getCollectionOfObjectValues(PermissionScope::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("preAuthorizedApplications", n -> this.setPreAuthorizedApplications(n.getCollectionOfObjectValues(PreAuthorizedApplication::createFromDiscriminatorValue)));
        deserializerMap.put("requestedAccessTokenVersion", n -> this.setRequestedAccessTokenVersion(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public List<UUID> getKnownClientApplications() {
        return (List)this.backingStore.get("knownClientApplications");
    }

    @Nullable
    public List<PermissionScope> getOauth2PermissionScopes() {
        return (List)this.backingStore.get("oauth2PermissionScopes");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<PreAuthorizedApplication> getPreAuthorizedApplications() {
        return (List)this.backingStore.get("preAuthorizedApplications");
    }

    @Nullable
    public Integer getRequestedAccessTokenVersion() {
        return (Integer)this.backingStore.get("requestedAccessTokenVersion");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("acceptMappedClaims", this.getAcceptMappedClaims());
        writer.writeCollectionOfPrimitiveValues("knownClientApplications", this.getKnownClientApplications());
        writer.writeCollectionOfObjectValues("oauth2PermissionScopes", this.getOauth2PermissionScopes());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("preAuthorizedApplications", this.getPreAuthorizedApplications());
        writer.writeIntegerValue("requestedAccessTokenVersion", this.getRequestedAccessTokenVersion());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAcceptMappedClaims(@Nullable Boolean value) {
        this.backingStore.set("acceptMappedClaims", (Object)value);
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setKnownClientApplications(@Nullable List<UUID> value) {
        this.backingStore.set("knownClientApplications", value);
    }

    public void setOauth2PermissionScopes(@Nullable List<PermissionScope> value) {
        this.backingStore.set("oauth2PermissionScopes", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPreAuthorizedApplications(@Nullable List<PreAuthorizedApplication> value) {
        this.backingStore.set("preAuthorizedApplications", value);
    }

    public void setRequestedAccessTokenVersion(@Nullable Integer value) {
        this.backingStore.set("requestedAccessTokenVersion", (Object)value);
    }
}

