/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.Extension;
import com.microsoft.graph.models.ScopedRoleMembership;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AdministrativeUnit
extends DirectoryObject
implements Parsable {
    public AdministrativeUnit() {
        this.setOdataType("#microsoft.graph.administrativeUnit");
    }

    @Nonnull
    public static AdministrativeUnit createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AdministrativeUnit();
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public List<Extension> getExtensions() {
        return (List)this.backingStore.get("extensions");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("extensions", n -> this.setExtensions(n.getCollectionOfObjectValues(Extension::createFromDiscriminatorValue)));
        deserializerMap.put("members", n -> this.setMembers(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("scopedRoleMembers", n -> this.setScopedRoleMembers(n.getCollectionOfObjectValues(ScopedRoleMembership::createFromDiscriminatorValue)));
        deserializerMap.put("visibility", n -> this.setVisibility(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public List<DirectoryObject> getMembers() {
        return (List)this.backingStore.get("members");
    }

    @Nullable
    public List<ScopedRoleMembership> getScopedRoleMembers() {
        return (List)this.backingStore.get("scopedRoleMembers");
    }

    @Nullable
    public String getVisibility() {
        return (String)this.backingStore.get("visibility");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeCollectionOfObjectValues("extensions", this.getExtensions());
        writer.writeCollectionOfObjectValues("members", this.getMembers());
        writer.writeCollectionOfObjectValues("scopedRoleMembers", this.getScopedRoleMembers());
        writer.writeStringValue("visibility", this.getVisibility());
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setExtensions(@Nullable List<Extension> value) {
        this.backingStore.set("extensions", value);
    }

    public void setMembers(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("members", value);
    }

    public void setScopedRoleMembers(@Nullable List<ScopedRoleMembership> value) {
        this.backingStore.set("scopedRoleMembers", value);
    }

    public void setVisibility(@Nullable String value) {
        this.backingStore.set("visibility", (Object)value);
    }
}

