/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.drives.item.items.item;

import com.microsoft.graph.drives.item.items.item.analytics.AnalyticsRequestBuilder;
import com.microsoft.graph.drives.item.items.item.assignsensitivitylabel.AssignSensitivityLabelRequestBuilder;
import com.microsoft.graph.drives.item.items.item.checkin.CheckinRequestBuilder;
import com.microsoft.graph.drives.item.items.item.checkout.CheckoutRequestBuilder;
import com.microsoft.graph.drives.item.items.item.children.ChildrenRequestBuilder;
import com.microsoft.graph.drives.item.items.item.content.ContentRequestBuilder;
import com.microsoft.graph.drives.item.items.item.copy.CopyRequestBuilder;
import com.microsoft.graph.drives.item.items.item.createdbyuser.CreatedByUserRequestBuilder;
import com.microsoft.graph.drives.item.items.item.createlink.CreateLinkRequestBuilder;
import com.microsoft.graph.drives.item.items.item.createuploadsession.CreateUploadSessionRequestBuilder;
import com.microsoft.graph.drives.item.items.item.delta.DeltaRequestBuilder;
import com.microsoft.graph.drives.item.items.item.deltawithtoken.DeltaWithTokenRequestBuilder;
import com.microsoft.graph.drives.item.items.item.extractsensitivitylabels.ExtractSensitivityLabelsRequestBuilder;
import com.microsoft.graph.drives.item.items.item.follow.FollowRequestBuilder;
import com.microsoft.graph.drives.item.items.item.getactivitiesbyinterval.GetActivitiesByIntervalRequestBuilder;
import com.microsoft.graph.drives.item.items.item.getactivitiesbyintervalwithstartdatetimewithenddatetimewithinterval.GetActivitiesByIntervalWithStartDateTimeWithEndDateTimeWithIntervalRequestBuilder;
import com.microsoft.graph.drives.item.items.item.invite.InviteRequestBuilder;
import com.microsoft.graph.drives.item.items.item.lastmodifiedbyuser.LastModifiedByUserRequestBuilder;
import com.microsoft.graph.drives.item.items.item.listitem.ListItemRequestBuilder;
import com.microsoft.graph.drives.item.items.item.permanentdelete.PermanentDeleteRequestBuilder;
import com.microsoft.graph.drives.item.items.item.permissions.PermissionsRequestBuilder;
import com.microsoft.graph.drives.item.items.item.preview.PreviewRequestBuilder;
import com.microsoft.graph.drives.item.items.item.restore.RestoreRequestBuilder;
import com.microsoft.graph.drives.item.items.item.retentionlabel.RetentionLabelRequestBuilder;
import com.microsoft.graph.drives.item.items.item.searchwithq.SearchWithQRequestBuilder;
import com.microsoft.graph.drives.item.items.item.subscriptions.SubscriptionsRequestBuilder;
import com.microsoft.graph.drives.item.items.item.thumbnails.ThumbnailsRequestBuilder;
import com.microsoft.graph.drives.item.items.item.unfollow.UnfollowRequestBuilder;
import com.microsoft.graph.drives.item.items.item.validatepermission.ValidatePermissionRequestBuilder;
import com.microsoft.graph.drives.item.items.item.versions.VersionsRequestBuilder;
import com.microsoft.graph.drives.item.items.item.workbook.WorkbookRequestBuilder;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DriveItemItemRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public AnalyticsRequestBuilder analytics() {
        return new AnalyticsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public AssignSensitivityLabelRequestBuilder assignSensitivityLabel() {
        return new AssignSensitivityLabelRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CheckinRequestBuilder checkin() {
        return new CheckinRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CheckoutRequestBuilder checkout() {
        return new CheckoutRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ChildrenRequestBuilder children() {
        return new ChildrenRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ContentRequestBuilder content() {
        return new ContentRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CopyRequestBuilder copy() {
        return new CopyRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CreatedByUserRequestBuilder createdByUser() {
        return new CreatedByUserRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CreateLinkRequestBuilder createLink() {
        return new CreateLinkRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CreateUploadSessionRequestBuilder createUploadSession() {
        return new CreateUploadSessionRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public DeltaRequestBuilder delta() {
        return new DeltaRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ExtractSensitivityLabelsRequestBuilder extractSensitivityLabels() {
        return new ExtractSensitivityLabelsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public FollowRequestBuilder follow() {
        return new FollowRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public GetActivitiesByIntervalRequestBuilder getActivitiesByInterval() {
        return new GetActivitiesByIntervalRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public InviteRequestBuilder invite() {
        return new InviteRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public LastModifiedByUserRequestBuilder lastModifiedByUser() {
        return new LastModifiedByUserRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ListItemRequestBuilder listItem() {
        return new ListItemRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PermanentDeleteRequestBuilder permanentDelete() {
        return new PermanentDeleteRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PermissionsRequestBuilder permissions() {
        return new PermissionsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PreviewRequestBuilder preview() {
        return new PreviewRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public RestoreRequestBuilder restore() {
        return new RestoreRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public RetentionLabelRequestBuilder retentionLabel() {
        return new RetentionLabelRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SubscriptionsRequestBuilder subscriptions() {
        return new SubscriptionsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ThumbnailsRequestBuilder thumbnails() {
        return new ThumbnailsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public UnfollowRequestBuilder unfollow() {
        return new UnfollowRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ValidatePermissionRequestBuilder validatePermission() {
        return new ValidatePermissionRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public VersionsRequestBuilder versions() {
        return new VersionsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public WorkbookRequestBuilder workbook() {
        return new WorkbookRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public DriveItemItemRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/drives/{drive%2Did}/items/{driveItem%2Did}{?%24expand,%24select}", pathParameters);
    }

    public DriveItemItemRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/drives/{drive%2Did}/items/{driveItem%2Did}{?%24expand,%24select}", rawUrl);
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nonnull
    public DeltaWithTokenRequestBuilder deltaWithToken(@Nonnull String token) {
        Objects.requireNonNull(token);
        return new DeltaWithTokenRequestBuilder(this.pathParameters, this.requestAdapter, token);
    }

    @Nullable
    public DriveItem get() {
        return this.get(null);
    }

    @Nullable
    public DriveItem get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (DriveItem)this.requestAdapter.send(requestInfo, errorMapping, DriveItem::createFromDiscriminatorValue);
    }

    @Nonnull
    public GetActivitiesByIntervalWithStartDateTimeWithEndDateTimeWithIntervalRequestBuilder getActivitiesByIntervalWithStartDateTimeWithEndDateTimeWithInterval(@Nonnull String endDateTime, @Nonnull String interval, @Nonnull String startDateTime) {
        Objects.requireNonNull(endDateTime);
        Objects.requireNonNull(interval);
        Objects.requireNonNull(startDateTime);
        return new GetActivitiesByIntervalWithStartDateTimeWithEndDateTimeWithIntervalRequestBuilder(this.pathParameters, this.requestAdapter, endDateTime, interval, startDateTime);
    }

    @Nullable
    public DriveItem patch(@Nonnull DriveItem body) {
        return this.patch(body, null);
    }

    @Nullable
    public DriveItem patch(@Nonnull DriveItem body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (DriveItem)this.requestAdapter.send(requestInfo, errorMapping, DriveItem::createFromDiscriminatorValue);
    }

    @Nonnull
    public SearchWithQRequestBuilder searchWithQ(@Nonnull String q) {
        Objects.requireNonNull(q);
        return new SearchWithQRequestBuilder(this.pathParameters, this.requestAdapter, q);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.DELETE, "{+baseurl}/drives/{drive%2Did}/items/{driveItem%2Did}", (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new DeleteRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull DriveItem body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull DriveItem body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, "{+baseurl}/drives/{drive%2Did}/items/{driveItem%2Did}", (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public DriveItemItemRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new DriveItemItemRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }

    public class DeleteRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

