/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.shares.item;

import com.microsoft.graph.models.SharedDriveItem;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.shares.item.createdbyuser.CreatedByUserRequestBuilder;
import com.microsoft.graph.shares.item.driveitem.DriveItemRequestBuilder;
import com.microsoft.graph.shares.item.items.ItemsRequestBuilder;
import com.microsoft.graph.shares.item.lastmodifiedbyuser.LastModifiedByUserRequestBuilder;
import com.microsoft.graph.shares.item.list.ListRequestBuilder;
import com.microsoft.graph.shares.item.listitem.ListItemRequestBuilder;
import com.microsoft.graph.shares.item.permission.PermissionRequestBuilder;
import com.microsoft.graph.shares.item.root.RootRequestBuilder;
import com.microsoft.graph.shares.item.site.SiteRequestBuilder;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SharedDriveItemItemRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public CreatedByUserRequestBuilder createdByUser() {
        return new CreatedByUserRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public DriveItemRequestBuilder driveItem() {
        return new DriveItemRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ItemsRequestBuilder items() {
        return new ItemsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public LastModifiedByUserRequestBuilder lastModifiedByUser() {
        return new LastModifiedByUserRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ListRequestBuilder list() {
        return new ListRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ListItemRequestBuilder listItem() {
        return new ListItemRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PermissionRequestBuilder permission() {
        return new PermissionRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public RootRequestBuilder root() {
        return new RootRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SiteRequestBuilder site() {
        return new SiteRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public SharedDriveItemItemRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/shares/{sharedDriveItem%2Did}{?%24expand,%24select}", pathParameters);
    }

    public SharedDriveItemItemRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/shares/{sharedDriveItem%2Did}{?%24expand,%24select}", rawUrl);
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nullable
    public SharedDriveItem get() {
        return this.get(null);
    }

    @Nullable
    public SharedDriveItem get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (SharedDriveItem)this.requestAdapter.send(requestInfo, errorMapping, SharedDriveItem::createFromDiscriminatorValue);
    }

    @Nullable
    public SharedDriveItem patch(@Nonnull SharedDriveItem body) {
        return this.patch(body, null);
    }

    @Nullable
    public SharedDriveItem patch(@Nonnull SharedDriveItem body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (SharedDriveItem)this.requestAdapter.send(requestInfo, errorMapping, SharedDriveItem::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.DELETE, "{+baseurl}/shares/{sharedDriveItem%2Did}", (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new DeleteRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull SharedDriveItem body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull SharedDriveItem body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, "{+baseurl}/shares/{sharedDriveItem%2Did}", (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public SharedDriveItemItemRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new SharedDriveItemItemRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }

    public class DeleteRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

