/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.PrivilegedAccessGroupAssignmentScheduleRequest;
import com.microsoft.graph.models.PrivilegedAccessGroupEligibilityScheduleRequest;
import com.microsoft.graph.models.Request;
import com.microsoft.graph.models.RequestSchedule;
import com.microsoft.graph.models.ScheduleRequestActions;
import com.microsoft.graph.models.TicketInfo;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PrivilegedAccessScheduleRequest
extends Request
implements Parsable {
    @Nonnull
    public static PrivilegedAccessScheduleRequest createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.privilegedAccessGroupAssignmentScheduleRequest": {
                    return new PrivilegedAccessGroupAssignmentScheduleRequest();
                }
                case "#microsoft.graph.privilegedAccessGroupEligibilityScheduleRequest": {
                    return new PrivilegedAccessGroupEligibilityScheduleRequest();
                }
            }
        }
        return new PrivilegedAccessScheduleRequest();
    }

    @Nullable
    public ScheduleRequestActions getAction() {
        return (ScheduleRequestActions)((Object)this.backingStore.get("action"));
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("action", n -> this.setAction((ScheduleRequestActions)n.getEnumValue(ScheduleRequestActions::forValue)));
        deserializerMap.put("isValidationOnly", n -> this.setIsValidationOnly(n.getBooleanValue()));
        deserializerMap.put("justification", n -> this.setJustification(n.getStringValue()));
        deserializerMap.put("scheduleInfo", n -> this.setScheduleInfo((RequestSchedule)n.getObjectValue(RequestSchedule::createFromDiscriminatorValue)));
        deserializerMap.put("ticketInfo", n -> this.setTicketInfo((TicketInfo)n.getObjectValue(TicketInfo::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsValidationOnly() {
        return (Boolean)this.backingStore.get("isValidationOnly");
    }

    @Nullable
    public String getJustification() {
        return (String)this.backingStore.get("justification");
    }

    @Nullable
    public RequestSchedule getScheduleInfo() {
        return (RequestSchedule)this.backingStore.get("scheduleInfo");
    }

    @Nullable
    public TicketInfo getTicketInfo() {
        return (TicketInfo)this.backingStore.get("ticketInfo");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeEnumValue("action", (Enum)this.getAction());
        writer.writeBooleanValue("isValidationOnly", this.getIsValidationOnly());
        writer.writeStringValue("justification", this.getJustification());
        writer.writeObjectValue("scheduleInfo", (Parsable)this.getScheduleInfo(), new Parsable[0]);
        writer.writeObjectValue("ticketInfo", (Parsable)this.getTicketInfo(), new Parsable[0]);
    }

    public void setAction(@Nullable ScheduleRequestActions value) {
        this.backingStore.set("action", (Object)value);
    }

    public void setIsValidationOnly(@Nullable Boolean value) {
        this.backingStore.set("isValidationOnly", (Object)value);
    }

    public void setJustification(@Nullable String value) {
        this.backingStore.set("justification", (Object)value);
    }

    public void setScheduleInfo(@Nullable RequestSchedule value) {
        this.backingStore.set("scheduleInfo", (Object)value);
    }

    public void setTicketInfo(@Nullable TicketInfo value) {
        this.backingStore.set("ticketInfo", (Object)value);
    }
}

