/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.identitygovernance;

import com.microsoft.graph.identitygovernance.accessreviews.AccessReviewsRequestBuilder;
import com.microsoft.graph.identitygovernance.appconsent.AppConsentRequestBuilder;
import com.microsoft.graph.identitygovernance.entitlementmanagement.EntitlementManagementRequestBuilder;
import com.microsoft.graph.identitygovernance.lifecycleworkflows.LifecycleWorkflowsRequestBuilder;
import com.microsoft.graph.identitygovernance.privilegedaccess.PrivilegedAccessRequestBuilder;
import com.microsoft.graph.identitygovernance.termsofuse.TermsOfUseRequestBuilder;
import com.microsoft.graph.models.IdentityGovernance;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class IdentityGovernanceRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public AccessReviewsRequestBuilder accessReviews() {
        return new AccessReviewsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public AppConsentRequestBuilder appConsent() {
        return new AppConsentRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public EntitlementManagementRequestBuilder entitlementManagement() {
        return new EntitlementManagementRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public LifecycleWorkflowsRequestBuilder lifecycleWorkflows() {
        return new LifecycleWorkflowsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PrivilegedAccessRequestBuilder privilegedAccess() {
        return new PrivilegedAccessRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public TermsOfUseRequestBuilder termsOfUse() {
        return new TermsOfUseRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public IdentityGovernanceRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/identityGovernance{?%24expand,%24select}", pathParameters);
    }

    public IdentityGovernanceRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/identityGovernance{?%24expand,%24select}", rawUrl);
    }

    @Nullable
    public IdentityGovernance get() {
        return this.get(null);
    }

    @Nullable
    public IdentityGovernance get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (IdentityGovernance)this.requestAdapter.send(requestInfo, errorMapping, IdentityGovernance::createFromDiscriminatorValue);
    }

    @Nullable
    public IdentityGovernance patch(@Nonnull IdentityGovernance body) {
        return this.patch(body, null);
    }

    @Nullable
    public IdentityGovernance patch(@Nonnull IdentityGovernance body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (IdentityGovernance)this.requestAdapter.send(requestInfo, errorMapping, IdentityGovernance::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull IdentityGovernance body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull IdentityGovernance body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, "{+baseurl}/identityGovernance", (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public IdentityGovernanceRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new IdentityGovernanceRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }
}

