/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.solutions.backuprestore;

import com.microsoft.graph.models.BackupRestoreRoot;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.solutions.backuprestore.driveinclusionrules.DriveInclusionRulesRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.driveprotectionunits.DriveProtectionUnitsRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.enable.EnableRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.exchangeprotectionpolicies.ExchangeProtectionPoliciesRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.exchangerestoresessions.ExchangeRestoreSessionsRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.mailboxinclusionrules.MailboxInclusionRulesRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.mailboxprotectionunits.MailboxProtectionUnitsRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.onedriveforbusinessprotectionpolicies.OneDriveForBusinessProtectionPoliciesRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.onedriveforbusinessrestoresessions.OneDriveForBusinessRestoreSessionsRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.protectionpolicies.ProtectionPoliciesRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.protectionunits.ProtectionUnitsRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.restorepoints.RestorePointsRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.restoresessions.RestoreSessionsRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.serviceapps.ServiceAppsRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.sharepointprotectionpolicies.SharePointProtectionPoliciesRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.sharepointrestoresessions.SharePointRestoreSessionsRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.siteinclusionrules.SiteInclusionRulesRequestBuilder;
import com.microsoft.graph.solutions.backuprestore.siteprotectionunits.SiteProtectionUnitsRequestBuilder;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BackupRestoreRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public DriveInclusionRulesRequestBuilder driveInclusionRules() {
        return new DriveInclusionRulesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public DriveProtectionUnitsRequestBuilder driveProtectionUnits() {
        return new DriveProtectionUnitsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public EnableRequestBuilder enable() {
        return new EnableRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ExchangeProtectionPoliciesRequestBuilder exchangeProtectionPolicies() {
        return new ExchangeProtectionPoliciesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ExchangeRestoreSessionsRequestBuilder exchangeRestoreSessions() {
        return new ExchangeRestoreSessionsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public MailboxInclusionRulesRequestBuilder mailboxInclusionRules() {
        return new MailboxInclusionRulesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public MailboxProtectionUnitsRequestBuilder mailboxProtectionUnits() {
        return new MailboxProtectionUnitsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public OneDriveForBusinessProtectionPoliciesRequestBuilder oneDriveForBusinessProtectionPolicies() {
        return new OneDriveForBusinessProtectionPoliciesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public OneDriveForBusinessRestoreSessionsRequestBuilder oneDriveForBusinessRestoreSessions() {
        return new OneDriveForBusinessRestoreSessionsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ProtectionPoliciesRequestBuilder protectionPolicies() {
        return new ProtectionPoliciesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ProtectionUnitsRequestBuilder protectionUnits() {
        return new ProtectionUnitsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public RestorePointsRequestBuilder restorePoints() {
        return new RestorePointsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public RestoreSessionsRequestBuilder restoreSessions() {
        return new RestoreSessionsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ServiceAppsRequestBuilder serviceApps() {
        return new ServiceAppsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SharePointProtectionPoliciesRequestBuilder sharePointProtectionPolicies() {
        return new SharePointProtectionPoliciesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SharePointRestoreSessionsRequestBuilder sharePointRestoreSessions() {
        return new SharePointRestoreSessionsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SiteInclusionRulesRequestBuilder siteInclusionRules() {
        return new SiteInclusionRulesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SiteProtectionUnitsRequestBuilder siteProtectionUnits() {
        return new SiteProtectionUnitsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public BackupRestoreRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/solutions/backupRestore{?%24expand,%24select}", pathParameters);
    }

    public BackupRestoreRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/solutions/backupRestore{?%24expand,%24select}", rawUrl);
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nullable
    public BackupRestoreRoot get() {
        return this.get(null);
    }

    @Nullable
    public BackupRestoreRoot get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (BackupRestoreRoot)this.requestAdapter.send(requestInfo, errorMapping, BackupRestoreRoot::createFromDiscriminatorValue);
    }

    @Nullable
    public BackupRestoreRoot patch(@Nonnull BackupRestoreRoot body) {
        return this.patch(body, null);
    }

    @Nullable
    public BackupRestoreRoot patch(@Nonnull BackupRestoreRoot body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (BackupRestoreRoot)this.requestAdapter.send(requestInfo, errorMapping, BackupRestoreRoot::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.DELETE, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new DeleteRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull BackupRestoreRoot body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull BackupRestoreRoot body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public BackupRestoreRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new BackupRestoreRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }

    public class DeleteRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

