/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.security.DataSourceContainerStatus;
import com.microsoft.graph.models.security.DataSourceHoldStatus;
import com.microsoft.graph.models.security.EdiscoveryCustodian;
import com.microsoft.graph.models.security.EdiscoveryNoncustodialDataSource;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DataSourceContainer
extends Entity
implements Parsable {
    @Nonnull
    public static DataSourceContainer createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.security.ediscoveryCustodian": {
                    return new EdiscoveryCustodian();
                }
                case "#microsoft.graph.security.ediscoveryNoncustodialDataSource": {
                    return new EdiscoveryNoncustodialDataSource();
                }
            }
        }
        return new DataSourceContainer();
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("holdStatus", n -> this.setHoldStatus((DataSourceHoldStatus)n.getEnumValue(DataSourceHoldStatus::forValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("releasedDateTime", n -> this.setReleasedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("status", n -> this.setStatus((DataSourceContainerStatus)n.getEnumValue(DataSourceContainerStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public DataSourceHoldStatus getHoldStatus() {
        return (DataSourceHoldStatus)((Object)this.backingStore.get("holdStatus"));
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public OffsetDateTime getReleasedDateTime() {
        return (OffsetDateTime)this.backingStore.get("releasedDateTime");
    }

    @Nullable
    public DataSourceContainerStatus getStatus() {
        return (DataSourceContainerStatus)((Object)this.backingStore.get("status"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeEnumValue("holdStatus", (Enum)this.getHoldStatus());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeOffsetDateTimeValue("releasedDateTime", this.getReleasedDateTime());
        writer.writeEnumValue("status", (Enum)this.getStatus());
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setHoldStatus(@Nullable DataSourceHoldStatus value) {
        this.backingStore.set("holdStatus", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setReleasedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("releasedDateTime", (Object)value);
    }

    public void setStatus(@Nullable DataSourceContainerStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

