/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.EmailFileAssessmentRequest;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.FileAssessmentRequest;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.MailAssessmentRequest;
import com.microsoft.graph.models.ThreatAssessmentContentType;
import com.microsoft.graph.models.ThreatAssessmentRequestSource;
import com.microsoft.graph.models.ThreatAssessmentResult;
import com.microsoft.graph.models.ThreatAssessmentStatus;
import com.microsoft.graph.models.ThreatCategory;
import com.microsoft.graph.models.ThreatExpectedAssessment;
import com.microsoft.graph.models.UrlAssessmentRequest;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ThreatAssessmentRequest
extends Entity
implements Parsable {
    @Nonnull
    public static ThreatAssessmentRequest createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.emailFileAssessmentRequest": {
                    return new EmailFileAssessmentRequest();
                }
                case "#microsoft.graph.fileAssessmentRequest": {
                    return new FileAssessmentRequest();
                }
                case "#microsoft.graph.mailAssessmentRequest": {
                    return new MailAssessmentRequest();
                }
                case "#microsoft.graph.urlAssessmentRequest": {
                    return new UrlAssessmentRequest();
                }
            }
        }
        return new ThreatAssessmentRequest();
    }

    @Nullable
    public ThreatCategory getCategory() {
        return (ThreatCategory)((Object)this.backingStore.get("category"));
    }

    @Nullable
    public ThreatAssessmentContentType getContentType() {
        return (ThreatAssessmentContentType)((Object)this.backingStore.get("contentType"));
    }

    @Nullable
    public IdentitySet getCreatedBy() {
        return (IdentitySet)this.backingStore.get("createdBy");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public ThreatExpectedAssessment getExpectedAssessment() {
        return (ThreatExpectedAssessment)((Object)this.backingStore.get("expectedAssessment"));
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("category", n -> this.setCategory((ThreatCategory)n.getEnumValue(ThreatCategory::forValue)));
        deserializerMap.put("contentType", n -> this.setContentType((ThreatAssessmentContentType)n.getEnumValue(ThreatAssessmentContentType::forValue)));
        deserializerMap.put("createdBy", n -> this.setCreatedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("expectedAssessment", n -> this.setExpectedAssessment((ThreatExpectedAssessment)n.getEnumValue(ThreatExpectedAssessment::forValue)));
        deserializerMap.put("requestSource", n -> this.setRequestSource((ThreatAssessmentRequestSource)n.getEnumValue(ThreatAssessmentRequestSource::forValue)));
        deserializerMap.put("results", n -> this.setResults(n.getCollectionOfObjectValues(ThreatAssessmentResult::createFromDiscriminatorValue)));
        deserializerMap.put("status", n -> this.setStatus((ThreatAssessmentStatus)n.getEnumValue(ThreatAssessmentStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public ThreatAssessmentRequestSource getRequestSource() {
        return (ThreatAssessmentRequestSource)((Object)this.backingStore.get("requestSource"));
    }

    @Nullable
    public List<ThreatAssessmentResult> getResults() {
        return (List)this.backingStore.get("results");
    }

    @Nullable
    public ThreatAssessmentStatus getStatus() {
        return (ThreatAssessmentStatus)((Object)this.backingStore.get("status"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeEnumValue("category", (Enum)this.getCategory());
        writer.writeEnumValue("contentType", (Enum)this.getContentType());
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeEnumValue("expectedAssessment", (Enum)this.getExpectedAssessment());
        writer.writeEnumValue("requestSource", (Enum)this.getRequestSource());
        writer.writeCollectionOfObjectValues("results", this.getResults());
        writer.writeEnumValue("status", (Enum)this.getStatus());
    }

    public void setCategory(@Nullable ThreatCategory value) {
        this.backingStore.set("category", (Object)value);
    }

    public void setContentType(@Nullable ThreatAssessmentContentType value) {
        this.backingStore.set("contentType", (Object)value);
    }

    public void setCreatedBy(@Nullable IdentitySet value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setExpectedAssessment(@Nullable ThreatExpectedAssessment value) {
        this.backingStore.set("expectedAssessment", (Object)value);
    }

    public void setRequestSource(@Nullable ThreatAssessmentRequestSource value) {
        this.backingStore.set("requestSource", (Object)value);
    }

    public void setResults(@Nullable List<ThreatAssessmentResult> value) {
        this.backingStore.set("results", value);
    }

    public void setStatus(@Nullable ThreatAssessmentStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

