/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.FileStorageContainerCustomPropertyDictionary;
import com.microsoft.graph.models.FileStorageContainerSettings;
import com.microsoft.graph.models.FileStorageContainerStatus;
import com.microsoft.graph.models.FileStorageContainerViewpoint;
import com.microsoft.graph.models.Permission;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;

public class FileStorageContainer
extends Entity
implements Parsable {
    @Nonnull
    public static FileStorageContainer createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new FileStorageContainer();
    }

    @Nullable
    public UUID getContainerTypeId() {
        return (UUID)this.backingStore.get("containerTypeId");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public FileStorageContainerCustomPropertyDictionary getCustomProperties() {
        return (FileStorageContainerCustomPropertyDictionary)this.backingStore.get("customProperties");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public Drive getDrive() {
        return (Drive)this.backingStore.get("drive");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("containerTypeId", n -> this.setContainerTypeId(n.getUUIDValue()));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("customProperties", n -> this.setCustomProperties((FileStorageContainerCustomPropertyDictionary)n.getObjectValue(FileStorageContainerCustomPropertyDictionary::createFromDiscriminatorValue)));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("drive", n -> this.setDrive((Drive)n.getObjectValue(Drive::createFromDiscriminatorValue)));
        deserializerMap.put("permissions", n -> this.setPermissions(n.getCollectionOfObjectValues(Permission::createFromDiscriminatorValue)));
        deserializerMap.put("settings", n -> this.setSettings((FileStorageContainerSettings)n.getObjectValue(FileStorageContainerSettings::createFromDiscriminatorValue)));
        deserializerMap.put("status", n -> this.setStatus((FileStorageContainerStatus)n.getEnumValue(FileStorageContainerStatus::forValue)));
        deserializerMap.put("viewpoint", n -> this.setViewpoint((FileStorageContainerViewpoint)n.getObjectValue(FileStorageContainerViewpoint::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<Permission> getPermissions() {
        return (List)this.backingStore.get("permissions");
    }

    @Nullable
    public FileStorageContainerSettings getSettings() {
        return (FileStorageContainerSettings)this.backingStore.get("settings");
    }

    @Nullable
    public FileStorageContainerStatus getStatus() {
        return (FileStorageContainerStatus)((Object)this.backingStore.get("status"));
    }

    @Nullable
    public FileStorageContainerViewpoint getViewpoint() {
        return (FileStorageContainerViewpoint)this.backingStore.get("viewpoint");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeUUIDValue("containerTypeId", this.getContainerTypeId());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeObjectValue("customProperties", (Parsable)this.getCustomProperties(), new Parsable[0]);
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeObjectValue("drive", (Parsable)this.getDrive(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("permissions", this.getPermissions());
        writer.writeObjectValue("settings", (Parsable)this.getSettings(), new Parsable[0]);
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeObjectValue("viewpoint", (Parsable)this.getViewpoint(), new Parsable[0]);
    }

    public void setContainerTypeId(@Nullable UUID value) {
        this.backingStore.set("containerTypeId", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setCustomProperties(@Nullable FileStorageContainerCustomPropertyDictionary value) {
        this.backingStore.set("customProperties", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setDrive(@Nullable Drive value) {
        this.backingStore.set("drive", (Object)value);
    }

    public void setPermissions(@Nullable List<Permission> value) {
        this.backingStore.set("permissions", value);
    }

    public void setSettings(@Nullable FileStorageContainerSettings value) {
        this.backingStore.set("settings", (Object)value);
    }

    public void setStatus(@Nullable FileStorageContainerStatus value) {
        this.backingStore.set("status", (Object)value);
    }

    public void setViewpoint(@Nullable FileStorageContainerViewpoint value) {
        this.backingStore.set("viewpoint", (Object)value);
    }
}

