/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DeviceEnrollmentLimitConfiguration;
import com.microsoft.graph.models.DeviceEnrollmentPlatformRestrictionsConfiguration;
import com.microsoft.graph.models.DeviceEnrollmentWindowsHelloForBusinessConfiguration;
import com.microsoft.graph.models.EnrollmentConfigurationAssignment;
import com.microsoft.graph.models.Entity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DeviceEnrollmentConfiguration
extends Entity
implements Parsable {
    @Nonnull
    public static DeviceEnrollmentConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.deviceEnrollmentLimitConfiguration": {
                    return new DeviceEnrollmentLimitConfiguration();
                }
                case "#microsoft.graph.deviceEnrollmentPlatformRestrictionsConfiguration": {
                    return new DeviceEnrollmentPlatformRestrictionsConfiguration();
                }
                case "#microsoft.graph.deviceEnrollmentWindowsHelloForBusinessConfiguration": {
                    return new DeviceEnrollmentWindowsHelloForBusinessConfiguration();
                }
            }
        }
        return new DeviceEnrollmentConfiguration();
    }

    @Nullable
    public List<EnrollmentConfigurationAssignment> getAssignments() {
        return (List)this.backingStore.get("assignments");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("assignments", n -> this.setAssignments(n.getCollectionOfObjectValues(EnrollmentConfigurationAssignment::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("priority", n -> this.setPriority(n.getIntegerValue()));
        deserializerMap.put("version", n -> this.setVersion(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public Integer getPriority() {
        return (Integer)this.backingStore.get("priority");
    }

    @Nullable
    public Integer getVersion() {
        return (Integer)this.backingStore.get("version");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("assignments", this.getAssignments());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeIntegerValue("priority", this.getPriority());
        writer.writeIntegerValue("version", this.getVersion());
    }

    public void setAssignments(@Nullable List<EnrollmentConfigurationAssignment> value) {
        this.backingStore.set("assignments", value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setPriority(@Nullable Integer value) {
        this.backingStore.set("priority", (Object)value);
    }

    public void setVersion(@Nullable Integer value) {
        this.backingStore.set("version", (Object)value);
    }
}

