/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.FileAttachment;
import com.microsoft.graph.models.ItemAttachment;
import com.microsoft.graph.models.ReferenceAttachment;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Attachment
extends Entity
implements Parsable {
    @Nonnull
    public static Attachment createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.fileAttachment": {
                    return new FileAttachment();
                }
                case "#microsoft.graph.itemAttachment": {
                    return new ItemAttachment();
                }
                case "#microsoft.graph.referenceAttachment": {
                    return new ReferenceAttachment();
                }
            }
        }
        return new Attachment();
    }

    @Nullable
    public String getContentType() {
        return (String)this.backingStore.get("contentType");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("contentType", n -> this.setContentType(n.getStringValue()));
        deserializerMap.put("isInline", n -> this.setIsInline(n.getBooleanValue()));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("size", n -> this.setSize(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsInline() {
        return (Boolean)this.backingStore.get("isInline");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public Integer getSize() {
        return (Integer)this.backingStore.get("size");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("contentType", this.getContentType());
        writer.writeBooleanValue("isInline", this.getIsInline());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeStringValue("name", this.getName());
        writer.writeIntegerValue("size", this.getSize());
    }

    public void setContentType(@Nullable String value) {
        this.backingStore.set("contentType", (Object)value);
    }

    public void setIsInline(@Nullable Boolean value) {
        this.backingStore.set("isInline", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setSize(@Nullable Integer value) {
        this.backingStore.set("size", (Object)value);
    }
}

