/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.AlertEvidence;
import com.microsoft.graph.models.security.BlobContainerEvidence;
import com.microsoft.graph.models.security.FileHash;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BlobEvidence
extends AlertEvidence
implements Parsable {
    public BlobEvidence() {
        this.setOdataType("#microsoft.graph.security.blobEvidence");
    }

    @Nonnull
    public static BlobEvidence createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new BlobEvidence();
    }

    @Nullable
    public BlobContainerEvidence getBlobContainer() {
        return (BlobContainerEvidence)this.backingStore.get("blobContainer");
    }

    @Nullable
    public String getEtag() {
        return (String)this.backingStore.get("etag");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("blobContainer", n -> this.setBlobContainer((BlobContainerEvidence)n.getObjectValue(BlobContainerEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("etag", n -> this.setEtag(n.getStringValue()));
        deserializerMap.put("fileHashes", n -> this.setFileHashes(n.getCollectionOfObjectValues(FileHash::createFromDiscriminatorValue)));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("url", n -> this.setUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public List<FileHash> getFileHashes() {
        return (List)this.backingStore.get("fileHashes");
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public String getUrl() {
        return (String)this.backingStore.get("url");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("blobContainer", (Parsable)this.getBlobContainer(), new Parsable[0]);
        writer.writeStringValue("etag", this.getEtag());
        writer.writeCollectionOfObjectValues("fileHashes", this.getFileHashes());
        writer.writeStringValue("name", this.getName());
        writer.writeStringValue("url", this.getUrl());
    }

    public void setBlobContainer(@Nullable BlobContainerEvidence value) {
        this.backingStore.set("blobContainer", (Object)value);
    }

    public void setEtag(@Nullable String value) {
        this.backingStore.set("etag", (Object)value);
    }

    public void setFileHashes(@Nullable List<FileHash> value) {
        this.backingStore.set("fileHashes", value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setUrl(@Nullable String value) {
        this.backingStore.set("url", (Object)value);
    }
}

