/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.search;

import com.microsoft.graph.models.DevicePlatformType;
import com.microsoft.graph.models.search.AnswerKeyword;
import com.microsoft.graph.models.search.AnswerState;
import com.microsoft.graph.models.search.AnswerVariant;
import com.microsoft.graph.models.search.SearchAnswer;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Qna
extends SearchAnswer
implements Parsable {
    @Nonnull
    public static Qna createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Qna();
    }

    @Nullable
    public OffsetDateTime getAvailabilityEndDateTime() {
        return (OffsetDateTime)this.backingStore.get("availabilityEndDateTime");
    }

    @Nullable
    public OffsetDateTime getAvailabilityStartDateTime() {
        return (OffsetDateTime)this.backingStore.get("availabilityStartDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("availabilityEndDateTime", n -> this.setAvailabilityEndDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("availabilityStartDateTime", n -> this.setAvailabilityStartDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("groupIds", n -> this.setGroupIds(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("isSuggested", n -> this.setIsSuggested(n.getBooleanValue()));
        deserializerMap.put("keywords", n -> this.setKeywords((AnswerKeyword)n.getObjectValue(AnswerKeyword::createFromDiscriminatorValue)));
        deserializerMap.put("languageTags", n -> this.setLanguageTags(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("platforms", n -> this.setPlatforms(n.getCollectionOfEnumValues(DevicePlatformType::forValue)));
        deserializerMap.put("state", n -> this.setState((AnswerState)n.getEnumValue(AnswerState::forValue)));
        deserializerMap.put("targetedVariations", n -> this.setTargetedVariations(n.getCollectionOfObjectValues(AnswerVariant::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<String> getGroupIds() {
        return (List)this.backingStore.get("groupIds");
    }

    @Nullable
    public Boolean getIsSuggested() {
        return (Boolean)this.backingStore.get("isSuggested");
    }

    @Nullable
    public AnswerKeyword getKeywords() {
        return (AnswerKeyword)this.backingStore.get("keywords");
    }

    @Nullable
    public List<String> getLanguageTags() {
        return (List)this.backingStore.get("languageTags");
    }

    @Nullable
    public List<DevicePlatformType> getPlatforms() {
        return (List)this.backingStore.get("platforms");
    }

    @Nullable
    public AnswerState getState() {
        return (AnswerState)((Object)this.backingStore.get("state"));
    }

    @Nullable
    public List<AnswerVariant> getTargetedVariations() {
        return (List)this.backingStore.get("targetedVariations");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("availabilityEndDateTime", this.getAvailabilityEndDateTime());
        writer.writeOffsetDateTimeValue("availabilityStartDateTime", this.getAvailabilityStartDateTime());
        writer.writeCollectionOfPrimitiveValues("groupIds", this.getGroupIds());
        writer.writeBooleanValue("isSuggested", this.getIsSuggested());
        writer.writeObjectValue("keywords", (Parsable)this.getKeywords(), new Parsable[0]);
        writer.writeCollectionOfPrimitiveValues("languageTags", this.getLanguageTags());
        writer.writeCollectionOfEnumValues("platforms", this.getPlatforms());
        writer.writeEnumValue("state", (Enum)this.getState());
        writer.writeCollectionOfObjectValues("targetedVariations", this.getTargetedVariations());
    }

    public void setAvailabilityEndDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("availabilityEndDateTime", (Object)value);
    }

    public void setAvailabilityStartDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("availabilityStartDateTime", (Object)value);
    }

    public void setGroupIds(@Nullable List<String> value) {
        this.backingStore.set("groupIds", value);
    }

    public void setIsSuggested(@Nullable Boolean value) {
        this.backingStore.set("isSuggested", (Object)value);
    }

    public void setKeywords(@Nullable AnswerKeyword value) {
        this.backingStore.set("keywords", (Object)value);
    }

    public void setLanguageTags(@Nullable List<String> value) {
        this.backingStore.set("languageTags", value);
    }

    public void setPlatforms(@Nullable List<DevicePlatformType> value) {
        this.backingStore.set("platforms", value);
    }

    public void setState(@Nullable AnswerState value) {
        this.backingStore.set("state", (Object)value);
    }

    public void setTargetedVariations(@Nullable List<AnswerVariant> value) {
        this.backingStore.set("targetedVariations", value);
    }
}

