/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.identitygovernance;

import com.microsoft.graph.models.identitygovernance.Run;
import com.microsoft.graph.models.identitygovernance.TaskReport;
import com.microsoft.graph.models.identitygovernance.UserProcessingResult;
import com.microsoft.graph.models.identitygovernance.WorkflowBase;
import com.microsoft.graph.models.identitygovernance.WorkflowVersion;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Workflow
extends WorkflowBase
implements Parsable {
    public Workflow() {
        this.setOdataType("#microsoft.graph.identityGovernance.workflow");
    }

    @Nonnull
    public static Workflow createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Workflow();
    }

    @Nullable
    public OffsetDateTime getDeletedDateTime() {
        return (OffsetDateTime)this.backingStore.get("deletedDateTime");
    }

    @Nullable
    public List<UserProcessingResult> getExecutionScope() {
        return (List)this.backingStore.get("executionScope");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("deletedDateTime", n -> this.setDeletedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("executionScope", n -> this.setExecutionScope(n.getCollectionOfObjectValues(UserProcessingResult::createFromDiscriminatorValue)));
        deserializerMap.put("id", n -> this.setId(n.getStringValue()));
        deserializerMap.put("nextScheduleRunDateTime", n -> this.setNextScheduleRunDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("runs", n -> this.setRuns(n.getCollectionOfObjectValues(Run::createFromDiscriminatorValue)));
        deserializerMap.put("taskReports", n -> this.setTaskReports(n.getCollectionOfObjectValues(TaskReport::createFromDiscriminatorValue)));
        deserializerMap.put("userProcessingResults", n -> this.setUserProcessingResults(n.getCollectionOfObjectValues(UserProcessingResult::createFromDiscriminatorValue)));
        deserializerMap.put("version", n -> this.setVersion(n.getIntegerValue()));
        deserializerMap.put("versions", n -> this.setVersions(n.getCollectionOfObjectValues(WorkflowVersion::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getId() {
        return (String)this.backingStore.get("id");
    }

    @Nullable
    public OffsetDateTime getNextScheduleRunDateTime() {
        return (OffsetDateTime)this.backingStore.get("nextScheduleRunDateTime");
    }

    @Nullable
    public List<Run> getRuns() {
        return (List)this.backingStore.get("runs");
    }

    @Nullable
    public List<TaskReport> getTaskReports() {
        return (List)this.backingStore.get("taskReports");
    }

    @Nullable
    public List<UserProcessingResult> getUserProcessingResults() {
        return (List)this.backingStore.get("userProcessingResults");
    }

    @Nullable
    public Integer getVersion() {
        return (Integer)this.backingStore.get("version");
    }

    @Nullable
    public List<WorkflowVersion> getVersions() {
        return (List)this.backingStore.get("versions");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("deletedDateTime", this.getDeletedDateTime());
        writer.writeCollectionOfObjectValues("executionScope", this.getExecutionScope());
        writer.writeStringValue("id", this.getId());
        writer.writeOffsetDateTimeValue("nextScheduleRunDateTime", this.getNextScheduleRunDateTime());
        writer.writeCollectionOfObjectValues("runs", this.getRuns());
        writer.writeCollectionOfObjectValues("taskReports", this.getTaskReports());
        writer.writeCollectionOfObjectValues("userProcessingResults", this.getUserProcessingResults());
        writer.writeIntegerValue("version", this.getVersion());
        writer.writeCollectionOfObjectValues("versions", this.getVersions());
    }

    public void setDeletedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("deletedDateTime", (Object)value);
    }

    public void setExecutionScope(@Nullable List<UserProcessingResult> value) {
        this.backingStore.set("executionScope", value);
    }

    public void setId(@Nullable String value) {
        this.backingStore.set("id", (Object)value);
    }

    public void setNextScheduleRunDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("nextScheduleRunDateTime", (Object)value);
    }

    public void setRuns(@Nullable List<Run> value) {
        this.backingStore.set("runs", value);
    }

    public void setTaskReports(@Nullable List<TaskReport> value) {
        this.backingStore.set("taskReports", value);
    }

    public void setUserProcessingResults(@Nullable List<UserProcessingResult> value) {
        this.backingStore.set("userProcessingResults", value);
    }

    public void setVersion(@Nullable Integer value) {
        this.backingStore.set("version", (Object)value);
    }

    public void setVersions(@Nullable List<WorkflowVersion> value) {
        this.backingStore.set("versions", value);
    }
}

