/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.identitygovernance;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class RunSummary
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public RunSummary() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static RunSummary createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new RunSummary();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Integer getFailedRuns() {
        return (Integer)this.backingStore.get("failedRuns");
    }

    @Nullable
    public Integer getFailedTasks() {
        return (Integer)this.backingStore.get("failedTasks");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("failedRuns", n -> this.setFailedRuns(n.getIntegerValue()));
        deserializerMap.put("failedTasks", n -> this.setFailedTasks(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("successfulRuns", n -> this.setSuccessfulRuns(n.getIntegerValue()));
        deserializerMap.put("totalRuns", n -> this.setTotalRuns(n.getIntegerValue()));
        deserializerMap.put("totalTasks", n -> this.setTotalTasks(n.getIntegerValue()));
        deserializerMap.put("totalUsers", n -> this.setTotalUsers(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Integer getSuccessfulRuns() {
        return (Integer)this.backingStore.get("successfulRuns");
    }

    @Nullable
    public Integer getTotalRuns() {
        return (Integer)this.backingStore.get("totalRuns");
    }

    @Nullable
    public Integer getTotalTasks() {
        return (Integer)this.backingStore.get("totalTasks");
    }

    @Nullable
    public Integer getTotalUsers() {
        return (Integer)this.backingStore.get("totalUsers");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeIntegerValue("failedRuns", this.getFailedRuns());
        writer.writeIntegerValue("failedTasks", this.getFailedTasks());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeIntegerValue("successfulRuns", this.getSuccessfulRuns());
        writer.writeIntegerValue("totalRuns", this.getTotalRuns());
        writer.writeIntegerValue("totalTasks", this.getTotalTasks());
        writer.writeIntegerValue("totalUsers", this.getTotalUsers());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setFailedRuns(@Nullable Integer value) {
        this.backingStore.set("failedRuns", (Object)value);
    }

    public void setFailedTasks(@Nullable Integer value) {
        this.backingStore.set("failedTasks", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setSuccessfulRuns(@Nullable Integer value) {
        this.backingStore.set("successfulRuns", (Object)value);
    }

    public void setTotalRuns(@Nullable Integer value) {
        this.backingStore.set("totalRuns", (Object)value);
    }

    public void setTotalTasks(@Nullable Integer value) {
        this.backingStore.set("totalTasks", (Object)value);
    }

    public void setTotalUsers(@Nullable Integer value) {
        this.backingStore.set("totalUsers", (Object)value);
    }
}

