/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.externalconnectors;

import com.microsoft.graph.models.externalconnectors.Label;
import com.microsoft.graph.models.externalconnectors.PropertyType;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Property
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public Property() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static Property createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Property();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public List<String> getAliases() {
        return (List)this.backingStore.get("aliases");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(9);
        deserializerMap.put("aliases", n -> this.setAliases(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("isQueryable", n -> this.setIsQueryable(n.getBooleanValue()));
        deserializerMap.put("isRefinable", n -> this.setIsRefinable(n.getBooleanValue()));
        deserializerMap.put("isRetrievable", n -> this.setIsRetrievable(n.getBooleanValue()));
        deserializerMap.put("isSearchable", n -> this.setIsSearchable(n.getBooleanValue()));
        deserializerMap.put("labels", n -> this.setLabels(n.getCollectionOfEnumValues(Label::forValue)));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("type", n -> this.setType((PropertyType)n.getEnumValue(PropertyType::forValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsQueryable() {
        return (Boolean)this.backingStore.get("isQueryable");
    }

    @Nullable
    public Boolean getIsRefinable() {
        return (Boolean)this.backingStore.get("isRefinable");
    }

    @Nullable
    public Boolean getIsRetrievable() {
        return (Boolean)this.backingStore.get("isRetrievable");
    }

    @Nullable
    public Boolean getIsSearchable() {
        return (Boolean)this.backingStore.get("isSearchable");
    }

    @Nullable
    public List<Label> getLabels() {
        return (List)this.backingStore.get("labels");
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public PropertyType getType() {
        return (PropertyType)((Object)this.backingStore.get("type"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfPrimitiveValues("aliases", this.getAliases());
        writer.writeBooleanValue("isQueryable", this.getIsQueryable());
        writer.writeBooleanValue("isRefinable", this.getIsRefinable());
        writer.writeBooleanValue("isRetrievable", this.getIsRetrievable());
        writer.writeBooleanValue("isSearchable", this.getIsSearchable());
        writer.writeCollectionOfEnumValues("labels", this.getLabels());
        writer.writeStringValue("name", this.getName());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("type", (Enum)this.getType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAliases(@Nullable List<String> value) {
        this.backingStore.set("aliases", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setIsQueryable(@Nullable Boolean value) {
        this.backingStore.set("isQueryable", (Object)value);
    }

    public void setIsRefinable(@Nullable Boolean value) {
        this.backingStore.set("isRefinable", (Object)value);
    }

    public void setIsRetrievable(@Nullable Boolean value) {
        this.backingStore.set("isRetrievable", (Object)value);
    }

    public void setIsSearchable(@Nullable Boolean value) {
        this.backingStore.set("isSearchable", (Object)value);
    }

    public void setLabels(@Nullable List<Label> value) {
        this.backingStore.set("labels", value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setType(@Nullable PropertyType value) {
        this.backingStore.set("type", (Object)value);
    }
}

