/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.callrecords;

import com.microsoft.graph.models.callrecords.NetworkConnectionType;
import com.microsoft.graph.models.callrecords.NetworkTransportProtocol;
import com.microsoft.graph.models.callrecords.TraceRouteHop;
import com.microsoft.graph.models.callrecords.WifiBand;
import com.microsoft.graph.models.callrecords.WifiRadioType;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class NetworkInfo
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public NetworkInfo() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static NetworkInfo createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new NetworkInfo();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Float getBandwidthLowEventRatio() {
        return (Float)this.backingStore.get("bandwidthLowEventRatio");
    }

    @Nullable
    public String getBasicServiceSetIdentifier() {
        return (String)this.backingStore.get("basicServiceSetIdentifier");
    }

    @Nullable
    public NetworkConnectionType getConnectionType() {
        return (NetworkConnectionType)((Object)this.backingStore.get("connectionType"));
    }

    @Nullable
    public Float getDelayEventRatio() {
        return (Float)this.backingStore.get("delayEventRatio");
    }

    @Nullable
    public String getDnsSuffix() {
        return (String)this.backingStore.get("dnsSuffix");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(27);
        deserializerMap.put("bandwidthLowEventRatio", n -> this.setBandwidthLowEventRatio(n.getFloatValue()));
        deserializerMap.put("basicServiceSetIdentifier", n -> this.setBasicServiceSetIdentifier(n.getStringValue()));
        deserializerMap.put("connectionType", n -> this.setConnectionType((NetworkConnectionType)n.getEnumValue(NetworkConnectionType::forValue)));
        deserializerMap.put("delayEventRatio", n -> this.setDelayEventRatio(n.getFloatValue()));
        deserializerMap.put("dnsSuffix", n -> this.setDnsSuffix(n.getStringValue()));
        deserializerMap.put("ipAddress", n -> this.setIpAddress(n.getStringValue()));
        deserializerMap.put("linkSpeed", n -> this.setLinkSpeed(n.getLongValue()));
        deserializerMap.put("macAddress", n -> this.setMacAddress(n.getStringValue()));
        deserializerMap.put("networkTransportProtocol", n -> this.setNetworkTransportProtocol((NetworkTransportProtocol)n.getEnumValue(NetworkTransportProtocol::forValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("port", n -> this.setPort(n.getIntegerValue()));
        deserializerMap.put("receivedQualityEventRatio", n -> this.setReceivedQualityEventRatio(n.getFloatValue()));
        deserializerMap.put("reflexiveIPAddress", n -> this.setReflexiveIPAddress(n.getStringValue()));
        deserializerMap.put("relayIPAddress", n -> this.setRelayIPAddress(n.getStringValue()));
        deserializerMap.put("relayPort", n -> this.setRelayPort(n.getIntegerValue()));
        deserializerMap.put("sentQualityEventRatio", n -> this.setSentQualityEventRatio(n.getFloatValue()));
        deserializerMap.put("subnet", n -> this.setSubnet(n.getStringValue()));
        deserializerMap.put("traceRouteHops", n -> this.setTraceRouteHops(n.getCollectionOfObjectValues(TraceRouteHop::createFromDiscriminatorValue)));
        deserializerMap.put("wifiBand", n -> this.setWifiBand((WifiBand)n.getEnumValue(WifiBand::forValue)));
        deserializerMap.put("wifiBatteryCharge", n -> this.setWifiBatteryCharge(n.getIntegerValue()));
        deserializerMap.put("wifiChannel", n -> this.setWifiChannel(n.getIntegerValue()));
        deserializerMap.put("wifiMicrosoftDriver", n -> this.setWifiMicrosoftDriver(n.getStringValue()));
        deserializerMap.put("wifiMicrosoftDriverVersion", n -> this.setWifiMicrosoftDriverVersion(n.getStringValue()));
        deserializerMap.put("wifiRadioType", n -> this.setWifiRadioType((WifiRadioType)n.getEnumValue(WifiRadioType::forValue)));
        deserializerMap.put("wifiSignalStrength", n -> this.setWifiSignalStrength(n.getIntegerValue()));
        deserializerMap.put("wifiVendorDriver", n -> this.setWifiVendorDriver(n.getStringValue()));
        deserializerMap.put("wifiVendorDriverVersion", n -> this.setWifiVendorDriverVersion(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getIpAddress() {
        return (String)this.backingStore.get("ipAddress");
    }

    @Nullable
    public Long getLinkSpeed() {
        return (Long)this.backingStore.get("linkSpeed");
    }

    @Nullable
    public String getMacAddress() {
        return (String)this.backingStore.get("macAddress");
    }

    @Nullable
    public NetworkTransportProtocol getNetworkTransportProtocol() {
        return (NetworkTransportProtocol)((Object)this.backingStore.get("networkTransportProtocol"));
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Integer getPort() {
        return (Integer)this.backingStore.get("port");
    }

    @Nullable
    public Float getReceivedQualityEventRatio() {
        return (Float)this.backingStore.get("receivedQualityEventRatio");
    }

    @Nullable
    public String getReflexiveIPAddress() {
        return (String)this.backingStore.get("reflexiveIPAddress");
    }

    @Nullable
    public String getRelayIPAddress() {
        return (String)this.backingStore.get("relayIPAddress");
    }

    @Nullable
    public Integer getRelayPort() {
        return (Integer)this.backingStore.get("relayPort");
    }

    @Nullable
    public Float getSentQualityEventRatio() {
        return (Float)this.backingStore.get("sentQualityEventRatio");
    }

    @Nullable
    public String getSubnet() {
        return (String)this.backingStore.get("subnet");
    }

    @Nullable
    public List<TraceRouteHop> getTraceRouteHops() {
        return (List)this.backingStore.get("traceRouteHops");
    }

    @Nullable
    public WifiBand getWifiBand() {
        return (WifiBand)((Object)this.backingStore.get("wifiBand"));
    }

    @Nullable
    public Integer getWifiBatteryCharge() {
        return (Integer)this.backingStore.get("wifiBatteryCharge");
    }

    @Nullable
    public Integer getWifiChannel() {
        return (Integer)this.backingStore.get("wifiChannel");
    }

    @Nullable
    public String getWifiMicrosoftDriver() {
        return (String)this.backingStore.get("wifiMicrosoftDriver");
    }

    @Nullable
    public String getWifiMicrosoftDriverVersion() {
        return (String)this.backingStore.get("wifiMicrosoftDriverVersion");
    }

    @Nullable
    public WifiRadioType getWifiRadioType() {
        return (WifiRadioType)((Object)this.backingStore.get("wifiRadioType"));
    }

    @Nullable
    public Integer getWifiSignalStrength() {
        return (Integer)this.backingStore.get("wifiSignalStrength");
    }

    @Nullable
    public String getWifiVendorDriver() {
        return (String)this.backingStore.get("wifiVendorDriver");
    }

    @Nullable
    public String getWifiVendorDriverVersion() {
        return (String)this.backingStore.get("wifiVendorDriverVersion");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeFloatValue("bandwidthLowEventRatio", this.getBandwidthLowEventRatio());
        writer.writeStringValue("basicServiceSetIdentifier", this.getBasicServiceSetIdentifier());
        writer.writeEnumValue("connectionType", (Enum)this.getConnectionType());
        writer.writeFloatValue("delayEventRatio", this.getDelayEventRatio());
        writer.writeStringValue("dnsSuffix", this.getDnsSuffix());
        writer.writeStringValue("ipAddress", this.getIpAddress());
        writer.writeLongValue("linkSpeed", this.getLinkSpeed());
        writer.writeStringValue("macAddress", this.getMacAddress());
        writer.writeEnumValue("networkTransportProtocol", (Enum)this.getNetworkTransportProtocol());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeIntegerValue("port", this.getPort());
        writer.writeFloatValue("receivedQualityEventRatio", this.getReceivedQualityEventRatio());
        writer.writeStringValue("reflexiveIPAddress", this.getReflexiveIPAddress());
        writer.writeStringValue("relayIPAddress", this.getRelayIPAddress());
        writer.writeIntegerValue("relayPort", this.getRelayPort());
        writer.writeFloatValue("sentQualityEventRatio", this.getSentQualityEventRatio());
        writer.writeStringValue("subnet", this.getSubnet());
        writer.writeCollectionOfObjectValues("traceRouteHops", this.getTraceRouteHops());
        writer.writeEnumValue("wifiBand", (Enum)this.getWifiBand());
        writer.writeIntegerValue("wifiBatteryCharge", this.getWifiBatteryCharge());
        writer.writeIntegerValue("wifiChannel", this.getWifiChannel());
        writer.writeStringValue("wifiMicrosoftDriver", this.getWifiMicrosoftDriver());
        writer.writeStringValue("wifiMicrosoftDriverVersion", this.getWifiMicrosoftDriverVersion());
        writer.writeEnumValue("wifiRadioType", (Enum)this.getWifiRadioType());
        writer.writeIntegerValue("wifiSignalStrength", this.getWifiSignalStrength());
        writer.writeStringValue("wifiVendorDriver", this.getWifiVendorDriver());
        writer.writeStringValue("wifiVendorDriverVersion", this.getWifiVendorDriverVersion());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setBandwidthLowEventRatio(@Nullable Float value) {
        this.backingStore.set("bandwidthLowEventRatio", (Object)value);
    }

    public void setBasicServiceSetIdentifier(@Nullable String value) {
        this.backingStore.set("basicServiceSetIdentifier", (Object)value);
    }

    public void setConnectionType(@Nullable NetworkConnectionType value) {
        this.backingStore.set("connectionType", (Object)value);
    }

    public void setDelayEventRatio(@Nullable Float value) {
        this.backingStore.set("delayEventRatio", (Object)value);
    }

    public void setDnsSuffix(@Nullable String value) {
        this.backingStore.set("dnsSuffix", (Object)value);
    }

    public void setIpAddress(@Nullable String value) {
        this.backingStore.set("ipAddress", (Object)value);
    }

    public void setLinkSpeed(@Nullable Long value) {
        this.backingStore.set("linkSpeed", (Object)value);
    }

    public void setMacAddress(@Nullable String value) {
        this.backingStore.set("macAddress", (Object)value);
    }

    public void setNetworkTransportProtocol(@Nullable NetworkTransportProtocol value) {
        this.backingStore.set("networkTransportProtocol", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPort(@Nullable Integer value) {
        this.backingStore.set("port", (Object)value);
    }

    public void setReceivedQualityEventRatio(@Nullable Float value) {
        this.backingStore.set("receivedQualityEventRatio", (Object)value);
    }

    public void setReflexiveIPAddress(@Nullable String value) {
        this.backingStore.set("reflexiveIPAddress", (Object)value);
    }

    public void setRelayIPAddress(@Nullable String value) {
        this.backingStore.set("relayIPAddress", (Object)value);
    }

    public void setRelayPort(@Nullable Integer value) {
        this.backingStore.set("relayPort", (Object)value);
    }

    public void setSentQualityEventRatio(@Nullable Float value) {
        this.backingStore.set("sentQualityEventRatio", (Object)value);
    }

    public void setSubnet(@Nullable String value) {
        this.backingStore.set("subnet", (Object)value);
    }

    public void setTraceRouteHops(@Nullable List<TraceRouteHop> value) {
        this.backingStore.set("traceRouteHops", value);
    }

    public void setWifiBand(@Nullable WifiBand value) {
        this.backingStore.set("wifiBand", (Object)value);
    }

    public void setWifiBatteryCharge(@Nullable Integer value) {
        this.backingStore.set("wifiBatteryCharge", (Object)value);
    }

    public void setWifiChannel(@Nullable Integer value) {
        this.backingStore.set("wifiChannel", (Object)value);
    }

    public void setWifiMicrosoftDriver(@Nullable String value) {
        this.backingStore.set("wifiMicrosoftDriver", (Object)value);
    }

    public void setWifiMicrosoftDriverVersion(@Nullable String value) {
        this.backingStore.set("wifiMicrosoftDriverVersion", (Object)value);
    }

    public void setWifiRadioType(@Nullable WifiRadioType value) {
        this.backingStore.set("wifiRadioType", (Object)value);
    }

    public void setWifiSignalStrength(@Nullable Integer value) {
        this.backingStore.set("wifiSignalStrength", (Object)value);
    }

    public void setWifiVendorDriver(@Nullable String value) {
        this.backingStore.set("wifiVendorDriver", (Object)value);
    }

    public void setWifiVendorDriverVersion(@Nullable String value) {
        this.backingStore.set("wifiVendorDriverVersion", (Object)value);
    }
}

